/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.server;

import com.sun.ts.tests.websocket.common.stringbean.StringBean;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.common.StringList;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.common.TypeEnum;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.server.ByteArrayMessageHandler;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.server.ByteArrayPartialMessageHandler;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.server.ByteBufferMessageHandler;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.server.ByteBufferPartialMessageHandler;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.server.InputStreamMessageHandler;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.server.LinkedListHashSetMessageHandler;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.server.PongMessageHandler;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.server.ReaderMessageHandler;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.server.StringBeanMessageHandler;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.server.StringListWholeMessageHandler;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.server.StringPartialMessageHandler;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.server.StringWholeMessageHandler;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.PongMessage;
import jakarta.websocket.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.LinkedList;

public class WSCServerEndpoint
extends Endpoint {
    private TypeEnum typeEnum;

    public WSCServerEndpoint(TypeEnum typeEnum) {
        this.typeEnum = typeEnum;
    }

    public void onOpen(Session session, EndpointConfig config) {
        switch (this.typeEnum) {
            case LINKEDLIST_HASHSET_TEXT: {
                LinkedList list = new LinkedList();
                Class<?> clzLLHS = list.getClass();
                session.addMessageHandler(clzLLHS, (MessageHandler.Whole)new LinkedListHashSetMessageHandler(session));
                break;
            }
            case LIST_TEXT: {
                session.addMessageHandler(StringList.class, (MessageHandler.Whole)new StringListWholeMessageHandler(session));
                break;
            }
            case STRINGBEAN: 
            case STRINGBEANSTREAM: 
            case STRINGBEANBINARY: 
            case STRINGBEANBINARYSTREAM: {
                session.addMessageHandler(StringBean.class, (MessageHandler.Whole)new StringBeanMessageHandler(session));
                break;
            }
            case STRING_WHOLE: {
                session.addMessageHandler(String.class, (MessageHandler.Whole)new StringWholeMessageHandler(session));
                break;
            }
            case STRING_PARTIAL: {
                session.addMessageHandler(String.class, (MessageHandler.Partial)new StringPartialMessageHandler(session));
                break;
            }
            case READER: {
                session.addMessageHandler(Reader.class, (MessageHandler.Whole)new ReaderMessageHandler(session));
                break;
            }
            case PONG: {
                session.addMessageHandler(PongMessage.class, (MessageHandler.Whole)new PongMessageHandler(session));
                break;
            }
            case BYTEBUFFER_WHOLE: {
                session.addMessageHandler(ByteBuffer.class, (MessageHandler.Whole)new ByteBufferMessageHandler(session));
                break;
            }
            case BYTEBUFFER_PARTIAL: {
                session.addMessageHandler(ByteBuffer.class, (MessageHandler.Partial)new ByteBufferPartialMessageHandler(session));
                break;
            }
            case BYTEARRAY_WHOLE: {
                byte[] ba = new byte[]{};
                Class<?> baclz = ba.getClass();
                session.addMessageHandler(baclz, (MessageHandler.Whole)new ByteArrayMessageHandler(session));
                break;
            }
            case BYTEARRAY_PARTIAL: {
                byte[] ba = new byte[]{};
                Class<?> baclz = ba.getClass();
                session.addMessageHandler(baclz, (MessageHandler.Partial)new ByteArrayPartialMessageHandler(session));
                break;
            }
            case INPUTSTREAM: {
                session.addMessageHandler(InputStream.class, (MessageHandler.Whole)new InputStreamMessageHandler(session));
                break;
            }
        }
    }

    public void onError(Session session, Throwable t) {
        super.onError(session, t);
        t.printStackTrace();
        String message = IOUtil.printStackTrace(t);
        try {
            session.getBasicRemote().sendText(message);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

