/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage;

import com.sun.ts.tests.websocket.common.client.EndpointCallback;
import com.sun.ts.tests.websocket.common.client.SendMessageCallback;
import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.impl.StringPongMessage;
import com.sun.ts.tests.websocket.common.stringbean.StringBean;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanBinaryDecoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanBinaryStreamDecoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextDecoder;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextStreamDecoder;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.OPS;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSBinaryDecoderAndSessionClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSBinaryDecoderClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSBinaryStreamDecoderAndSessionClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSBinaryStreamDecoderClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSByteArrayAndSessionClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSByteArrayClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSByteArrayPartialAndSessionClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSByteArrayPartialClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSByteBufferAndSessionClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSByteBufferClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSByteBufferPartialAndSessionClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSByteBufferPartialClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSCServer;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSDefaultMaxLengthClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSFullBooleanAndSessionClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSFullBooleanClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSFullByteAndSessionClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSFullByteClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSFullCharAndSessionClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSFullCharClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSFullDoubleAndSessionClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSFullDoubleClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSFullFloatAndSessionClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSFullFloatClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSFullLongAndSessionClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSFullLongClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSFullShortAndSessionClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSFullShortClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSInputStreamAndSessionClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSInputStreamClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSMaxLengthClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSPongMessageAndSessionClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSPongMessageClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSPrimitiveBooleanAndSessionClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSPrimitiveBooleanClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSPrimitiveByteAndSessionClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSPrimitiveByteClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSPrimitiveCharAndSessionClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSPrimitiveCharClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSPrimitiveDoubleAndSessionClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSPrimitiveDoubleClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSPrimitiveFloatAndSessionClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSPrimitiveFloatClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSPrimitiveIntAndSessionClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSPrimitiveIntClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSPrimitiveLongAndSessionClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSPrimitiveLongClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSPrimitiveShortAndSessionClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSPrimitiveShortClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSReaderAndSessionClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSReaderClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSStringAndSessionClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSStringClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSStringPartialAndSessionClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSStringPartialClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSTextDecoderAndSessionClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSTextDecoderClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSTextStreamDecoderAndSessionClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.clientendpointonmessage.WSTextStreamDecoderClientEndpoint;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Session;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = 7948609603037530363L;
    static final String ECHO = "Echo message to be sent to server endpoint";

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ws_ee_clientendpointonmessage_web.war");
        archive.addClasses(new Class[]{OPS.class, WSCServer.class});
        archive.addClasses(new Class[]{StringBean.class, StringBeanBinaryDecoder.class, StringBeanBinaryStreamDecoder.class, StringBeanTextDecoder.class, StringBeanTextStreamDecoder.class});
        archive.addClasses(new Class[]{IOUtil.class});
        archive.addClasses(new Class[]{StringPongMessage.class});
        return archive;
    }

    @Override
    @BeforeEach
    public void setup() throws Exception {
        this.setCountDownLatchCount(3);
        this.setContextRoot("ws_ee_clientendpointonmessage_web");
        this.addClientCallback(new EndpointCallback(){

            @Override
            public void onClose(Session session, CloseReason closeReason) {
                this.getCountDownLatch().countDown();
                super.onClose(session, closeReason);
            }
        });
        super.setup();
    }

    @Test
    public void echoStringTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSStringClientEndpoint());
        this.setProperty(WebSocketCommonClient.Property.CONTENT, ECHO);
        this.invoke(OPS.TEXT, ECHO);
    }

    @Test
    public void echoIntTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSPrimitiveIntClientEndpoint());
        int entity = Integer.MIN_VALUE;
        this.setEntity(entity);
        this.invoke(OPS.TEXT, String.valueOf(entity));
    }

    @Test
    public void echoByteTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSPrimitiveByteClientEndpoint());
        byte entity = 123;
        this.setEntity(entity);
        this.invoke(OPS.TEXT, String.valueOf(entity));
    }

    @Test
    public void echoCharTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSPrimitiveCharClientEndpoint());
        char entity = 'E';
        this.setEntity(Character.valueOf(entity));
        this.invoke(OPS.TEXT, String.valueOf(entity));
    }

    @Test
    public void echoBooleanTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSPrimitiveBooleanClientEndpoint());
        boolean entity = true;
        this.setEntity(entity);
        this.invoke(OPS.TEXT, String.valueOf(entity));
    }

    @Test
    public void echoShortTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSPrimitiveShortClientEndpoint());
        short entity = -32100;
        this.setEntity(entity);
        this.invoke(OPS.TEXT, String.valueOf(entity));
    }

    @Test
    public void echoDoubleTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSPrimitiveDoubleClientEndpoint());
        double entity = -1.234567888E7;
        this.setEntity(entity);
        this.invoke(OPS.TEXT, String.valueOf(entity));
    }

    @Test
    public void echoFloatTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSPrimitiveFloatClientEndpoint());
        float entity = -1.2345679E7f;
        this.setEntity(Float.valueOf(entity));
        this.invoke(OPS.TEXT, String.valueOf(entity));
    }

    @Test
    public void echoLongTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSPrimitiveLongClientEndpoint());
        long entity = Long.MIN_VALUE;
        this.setEntity(entity);
        this.invoke(OPS.TEXT, String.valueOf(entity));
    }

    @Test
    public void echoFullIntTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSFullLongClientEndpoint());
        Integer entity = Integer.MIN_VALUE;
        this.setEntity(entity);
        this.invoke(OPS.TEXT, entity.toString());
    }

    @Test
    public void echoFullByteTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSFullByteClientEndpoint());
        Byte entity = -128;
        this.setEntity(entity);
        this.invoke(OPS.TEXT, entity.toString());
    }

    @Test
    public void echoFullCharTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSFullCharClientEndpoint());
        Character entity = Character.valueOf('E');
        this.setEntity(entity);
        this.invoke(OPS.TEXT, entity.toString());
    }

    @Test
    public void echoFullBooleanTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSFullBooleanClientEndpoint());
        Boolean entity = true;
        this.setEntity(entity);
        this.invoke(OPS.TEXT, entity.toString());
    }

    @Test
    public void echoFullShortTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSFullShortClientEndpoint());
        Short entity = Short.MAX_VALUE;
        this.setEntity(entity);
        this.invoke(OPS.TEXT, entity.toString());
    }

    @Test
    public void echoFullDoubleTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSFullDoubleClientEndpoint());
        Double entity = Double.MIN_VALUE;
        this.setEntity(entity);
        this.invoke(OPS.TEXT, entity.toString());
    }

    @Test
    public void echoFullFloatTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSFullFloatClientEndpoint());
        Float entity = Float.valueOf(Float.MAX_VALUE);
        this.setEntity(entity);
        this.invoke(OPS.TEXT, entity.toString());
    }

    @Test
    public void echoFullLongTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSFullLongClientEndpoint());
        Long entity = Long.MAX_VALUE;
        this.setEntity(entity);
        this.invoke(OPS.TEXT, entity.toString());
    }

    @Test
    public void echoReaderTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSReaderClientEndpoint());
        this.setProperty(WebSocketCommonClient.Property.CONTENT, ECHO);
        this.invoke(OPS.TEXT, ECHO);
    }

    @Test
    public void echoTextDecoderTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSTextDecoderClientEndpoint());
        this.setProperty(WebSocketCommonClient.Property.CONTENT, ECHO);
        this.invoke(OPS.TEXT, ECHO);
    }

    @Test
    public void echoTextStreamDecoderTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSTextStreamDecoderClientEndpoint());
        this.setProperty(WebSocketCommonClient.Property.CONTENT, ECHO);
        this.invoke(OPS.TEXT, ECHO);
    }

    @Test
    public void echoStringAndSessionTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSStringAndSessionClientEndpoint());
        this.setProperty(WebSocketCommonClient.Property.CONTENT, ECHO);
        this.invoke(OPS.TEXT, ECHO);
    }

    @Test
    public void echoIntAndSessionTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSPrimitiveIntAndSessionClientEndpoint());
        int entity = Integer.MIN_VALUE;
        this.setEntity(entity);
        this.invoke(OPS.TEXT, String.valueOf(entity));
    }

    @Test
    public void echoByteAndSessionTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSPrimitiveByteAndSessionClientEndpoint());
        byte entity = 123;
        this.setEntity(entity);
        this.invoke(OPS.TEXT, String.valueOf(entity));
    }

    @Test
    public void echoCharAndSessionTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSPrimitiveCharAndSessionClientEndpoint());
        char entity = 'E';
        this.setEntity(Character.valueOf(entity));
        this.invoke(OPS.TEXT, String.valueOf(entity) + "char");
    }

    @Test
    public void echoBooleanAndSessionTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSPrimitiveBooleanAndSessionClientEndpoint());
        boolean entity = true;
        this.setEntity(entity);
        this.invoke(OPS.TEXT, String.valueOf(entity));
    }

    @Test
    public void echoShortAndSessionTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSPrimitiveShortAndSessionClientEndpoint());
        short entity = -32100;
        this.setEntity(entity);
        this.invoke(OPS.TEXT, String.valueOf(entity));
    }

    @Test
    public void echoDoubleAndSessionTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSPrimitiveDoubleAndSessionClientEndpoint());
        double entity = -1.234567888E7;
        this.setEntity(entity);
        this.invoke(OPS.TEXT, String.valueOf(entity));
    }

    @Test
    public void echoFloatAndSessionTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSPrimitiveFloatAndSessionClientEndpoint());
        float entity = -1.2345679E7f;
        this.setEntity(Float.valueOf(entity));
        this.invoke(OPS.TEXT, String.valueOf(entity));
    }

    @Test
    public void echoLongAndSessionTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSPrimitiveLongAndSessionClientEndpoint());
        long entity = Long.MIN_VALUE;
        this.setEntity(entity);
        this.invoke(OPS.TEXT, String.valueOf(entity));
    }

    @Test
    public void echoFullIntAndSessionTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSFullLongAndSessionClientEndpoint());
        Integer entity = Integer.MIN_VALUE;
        this.setEntity(entity);
        this.invoke(OPS.TEXT, entity.toString());
    }

    @Test
    public void echoFullByteAndSessionTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSFullByteAndSessionClientEndpoint());
        Byte entity = -128;
        this.setEntity(entity);
        this.invoke(OPS.TEXT, entity.toString());
    }

    @Test
    public void echoFullCharAndSessionTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSFullCharAndSessionClientEndpoint());
        Character entity = Character.valueOf('E');
        this.setEntity(entity);
        this.invoke(OPS.TEXT, entity.toString());
    }

    @Test
    public void echoFullBooleanAndSessionTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSFullBooleanAndSessionClientEndpoint());
        Boolean entity = true;
        this.setEntity(entity);
        this.invoke(OPS.TEXT, entity.toString());
    }

    @Test
    public void echoFullShortAndSessionTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSFullShortAndSessionClientEndpoint());
        Short entity = Short.MAX_VALUE;
        this.setEntity(entity);
        this.invoke(OPS.TEXT, entity.toString());
    }

    @Test
    public void echoFullDoubleAndSessionTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSFullDoubleAndSessionClientEndpoint());
        Double entity = Double.MIN_VALUE;
        this.setEntity(entity);
        this.invoke(OPS.TEXT, entity.toString());
    }

    @Test
    public void echoFullFloatAndSessionTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSFullFloatAndSessionClientEndpoint());
        Float entity = Float.valueOf(Float.MAX_VALUE);
        this.setEntity(entity);
        this.invoke(OPS.TEXT, entity.toString());
    }

    @Test
    public void echoFullLongAndSessionTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSFullLongAndSessionClientEndpoint());
        Long entity = Long.MAX_VALUE;
        this.setEntity(entity);
        this.invoke(OPS.TEXT, entity.toString());
    }

    @Test
    public void echoReaderAndSessionTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSReaderAndSessionClientEndpoint());
        this.setProperty(WebSocketCommonClient.Property.CONTENT, ECHO);
        this.invoke(OPS.TEXT, ECHO);
    }

    @Test
    public void echoTextDecoderAndSessionTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSTextDecoderAndSessionClientEndpoint());
        this.setProperty(WebSocketCommonClient.Property.CONTENT, ECHO);
        this.invoke(OPS.TEXT, ECHO);
    }

    @Test
    public void echoTextStreamDecoderAndSessionTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSTextStreamDecoderAndSessionClientEndpoint());
        this.setProperty(WebSocketCommonClient.Property.CONTENT, ECHO);
        this.invoke(OPS.TEXT, ECHO);
    }

    @Test
    public void partialStringTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSStringPartialClientEndpoint());
        String partial2 = "partialStringTest";
        String response = "Echo message to be sent to server endpoint_(false)" + partial2 + "(true)";
        this.setEntity("Echo message to be sent to server endpoint_" + partial2);
        this.invoke(OPS.TEXTPARTIAL, response);
    }

    @Test
    public void partialStringAndSessionTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSStringPartialAndSessionClientEndpoint());
        String partial2 = "partialStringAndSessionTest";
        String response = "Echo message to be sent to server endpoint_(false)" + partial2 + "(true)";
        this.setEntity("Echo message to be sent to server endpoint_" + partial2);
        this.invoke(OPS.TEXTPARTIAL, response);
    }

    @Test
    public void echoByteBufferTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSByteBufferClientEndpoint());
        this.setEntity(ByteBuffer.wrap(ECHO.getBytes()));
        this.invoke(OPS.BINARY, ECHO);
    }

    @Test
    public void byteBufferToBytesTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSByteArrayClientEndpoint());
        this.setEntity(ByteBuffer.wrap(ECHO.getBytes()));
        this.invoke(OPS.BINARY, ECHO);
    }

    @Test
    public void byteBufferToInputStreamTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSInputStreamClientEndpoint());
        this.setEntity(ByteBuffer.wrap(ECHO.getBytes()));
        this.invoke(OPS.BINARY, ECHO);
    }

    @Test
    public void byteBufferToBinaryDecoderTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSBinaryDecoderClientEndpoint());
        this.setEntity(ByteBuffer.wrap(ECHO.getBytes()));
        this.invoke(OPS.BINARY, ECHO);
    }

    @Test
    public void byteBufferToBinaryStreamDecoderTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSBinaryStreamDecoderClientEndpoint());
        this.setEntity(ByteBuffer.wrap(ECHO.getBytes()));
        this.invoke(OPS.BINARY, ECHO);
    }

    @Test
    public void pongToPongTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSPongMessageClientEndpoint());
        this.setEntity(ECHO);
        this.invoke(OPS.PONG, ECHO);
    }

    @Test
    public void pongToPongAndSessionTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSPongMessageAndSessionClientEndpoint());
        this.setEntity(ECHO);
        this.invoke(OPS.PONG, ECHO);
    }

    @Test
    public void echoByteBufferAndSessionTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSByteBufferAndSessionClientEndpoint());
        this.setEntity(ByteBuffer.wrap(ECHO.getBytes()));
        this.invoke(OPS.BINARY, ECHO);
    }

    @Test
    public void byteBufferToBytesAndSessionTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSByteArrayAndSessionClientEndpoint());
        this.setEntity(ByteBuffer.wrap(ECHO.getBytes()));
        this.invoke(OPS.BINARY, ECHO);
    }

    @Test
    public void byteBufferToInputStreamAndSessionTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSInputStreamAndSessionClientEndpoint());
        this.setEntity(ByteBuffer.wrap(ECHO.getBytes()));
        this.invoke(OPS.BINARY, ECHO);
    }

    @Test
    public void byteBufferToBinaryDecoderAndSessionTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSBinaryDecoderAndSessionClientEndpoint());
        this.setEntity(ByteBuffer.wrap(ECHO.getBytes()));
        this.invoke(OPS.BINARY, ECHO);
    }

    @Test
    public void byteBufferToBinaryStreamDecoderAndSessionTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSBinaryStreamDecoderAndSessionClientEndpoint());
        this.setEntity(ByteBuffer.wrap(ECHO.getBytes()));
        this.invoke(OPS.BINARY, ECHO);
    }

    @Test
    public void partialByteArrayTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSByteArrayPartialClientEndpoint());
        String partial2 = "partialByteArrayTest";
        String response = "Echo message to be sent to server endpoint_(false)" + partial2 + "(true)";
        this.setEntity(ByteBuffer.wrap(("Echo message to be sent to server endpoint_" + partial2).getBytes()));
        this.invoke(OPS.BINARYPARTIAL, response);
    }

    @Test
    public void partialByteArrayAndSessionTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSByteArrayPartialAndSessionClientEndpoint());
        String partial2 = "partialByteArrayAndSessionTest";
        String response = "Echo message to be sent to server endpoint_(false)" + partial2 + "(true)";
        this.setEntity(ByteBuffer.wrap(("Echo message to be sent to server endpoint_" + partial2).getBytes()));
        this.invoke(OPS.BINARYPARTIAL, response);
    }

    @Test
    public void partialByteBufferTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSByteBufferPartialClientEndpoint());
        String partial2 = "partialByteBufferTest";
        String response = "Echo message to be sent to server endpoint_(false)" + partial2 + "(true)";
        this.setEntity(ByteBuffer.wrap(("Echo message to be sent to server endpoint_" + partial2).getBytes()));
        this.invoke(OPS.BINARYPARTIAL, response);
    }

    @Test
    public void partialByteBufferAndSessionTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSByteBufferPartialAndSessionClientEndpoint());
        String partial2 = "partialByteBufferAndSessionTest";
        String response = "Echo message to be sent to server endpoint_(false)" + partial2 + "(true)";
        this.setEntity(ByteBuffer.wrap(("Echo message to be sent to server endpoint_" + partial2).getBytes()));
        this.invoke(OPS.BINARYPARTIAL, response);
    }

    @Test
    public void maxLengthOKTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSMaxLengthClientEndpoint());
        String entity = "12345";
        this.setEntity(entity);
        this.invoke(OPS.TEXT, entity);
    }

    @Test
    public void maxLengthFailsTest() throws Exception {
        this.setCountDownLatchCount(1);
        final AtomicInteger ai = new AtomicInteger(0);
        this.setEntity("123456");
        SendMessageCallback callback = new SendMessageCallback(this.entity){

            @Override
            public void onClose(Session session, CloseReason closeReason) {
                ai.set(closeReason.getCloseCode().getCode());
                this.getCountDownLatch().countDown();
            }
        };
        this.setClientCallback(callback);
        this.setAnnotatedClientEndpoint(new WSMaxLengthClientEndpoint());
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(OPS.TEXT));
        this.invoke(false);
        WSClientIT.assertEqualsInt(1009, ai.get(), "Unexpected close reason found", ai.get());
        WSClientIT.logMsg("Found expected close reason code", 1009);
    }

    @Test
    public void defaultMaxLengthTest() throws Exception {
        this.setAnnotatedClientEndpoint(new WSDefaultMaxLengthClientEndpoint());
        this.setEntity("123456789");
        this.invoke(OPS.TEXT, "-1");
    }

    private String buildRequest(OPS op) {
        return this.buildRequest("srv", "/", op.name());
    }

    private void invoke(OPS op, String search) throws Exception {
        this.setProperty(WebSocketCommonClient.Property.REQUEST, this.buildRequest(op));
        this.setProperty(WebSocketCommonClient.Property.SEARCH_STRING, search, search);
        this.invoke();
    }
}

