/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.ResultCodeInfo;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ExtendedOperationResultCodeInfo
implements Serializable {
    private static final long serialVersionUID = 2412562905271298484L;
    private final Double failedPercent;
    private final Long failedCount;
    private final Long totalCount;
    private final Map<String, Double> failedPercentsByOID;
    private final Map<String, Long> failedCountsByOID;
    private final Map<String, Long> totalCountsByOID;
    private final Map<String, Map<Integer, ResultCodeInfo>> resultCodeInfoMap;
    private final Map<String, String> requestNamesByOID;

    ExtendedOperationResultCodeInfo(MonitorEntry entry) {
        this.totalCount = entry.getLong("extended-op-total-count");
        this.failedCount = entry.getLong("extended-op-failed-count");
        this.failedPercent = entry.getDouble("extended-op-failed-percent");
        TreeMap<String, String> names = new TreeMap<String, String>();
        TreeMap<String, Long> totalCounts = new TreeMap<String, Long>();
        TreeMap<String, Long> failedCounts = new TreeMap<String, Long>();
        TreeMap<String, Double> failedPercents = new TreeMap<String, Double>();
        TreeMap<String, Map<Integer, ResultCodeInfo>> rcMaps = new TreeMap<String, Map<Integer, ResultCodeInfo>>();
        ReadOnlyEntry e = entry.getEntry();
        for (Attribute a : e.getAttributes()) {
            try {
                String lowerName = StaticUtils.toLowerCase(a.getName());
                if (!lowerName.startsWith("extended-op-") || !lowerName.endsWith("-total-count")) continue;
                String dashedOID = lowerName.substring(12, lowerName.length() - 12);
                String dottedOID = dashedOID.replace('-', '.');
                String name = entry.getString("extended-op-" + dashedOID + "-name");
                long total = a.getValueAsLong();
                long failed = entry.getLong("extended-op-" + dashedOID + "-failed-count");
                double failedPct = entry.getDouble("extended-op-" + dashedOID + "-failed-percent");
                names.put(dottedOID, name);
                totalCounts.put(dottedOID, total);
                failedCounts.put(dottedOID, failed);
                failedPercents.put(dottedOID, failedPct);
                rcMaps.put(dottedOID, ExtendedOperationResultCodeInfo.getRCMap(e, "extended-op-" + dashedOID + "-result-"));
            }
            catch (Exception ex) {
                Debug.debugException(ex);
            }
        }
        this.requestNamesByOID = Collections.unmodifiableMap(names);
        this.totalCountsByOID = Collections.unmodifiableMap(totalCounts);
        this.failedCountsByOID = Collections.unmodifiableMap(failedCounts);
        this.failedPercentsByOID = Collections.unmodifiableMap(failedPercents);
        this.resultCodeInfoMap = Collections.unmodifiableMap(rcMaps);
    }

    private static Map<Integer, ResultCodeInfo> getRCMap(Entry entry, String prefix) {
        TreeMap<Integer, ResultCodeInfo> m = new TreeMap<Integer, ResultCodeInfo>();
        for (Attribute a : entry.getAttributes()) {
            try {
                String lowerName = StaticUtils.toLowerCase(a.getName());
                if (!lowerName.startsWith(prefix) || !lowerName.endsWith("-name")) continue;
                int intValue = Integer.parseInt(lowerName.substring(prefix.length(), lowerName.length() - 5));
                String name = a.getValue();
                long count = entry.getAttributeValueAsLong(prefix + intValue + "-count");
                double percent = Double.parseDouble(entry.getAttributeValue(prefix + intValue + "-percent"));
                double totalResponseTimeMillis = Double.parseDouble(entry.getAttributeValue(prefix + intValue + "-total-response-time-millis"));
                double averageResponseTimeMillis = Double.parseDouble(entry.getAttributeValue(prefix + intValue + "-average-response-time-millis"));
                m.put(intValue, new ResultCodeInfo(intValue, name, OperationType.EXTENDED, count, percent, totalResponseTimeMillis, averageResponseTimeMillis));
            }
            catch (Exception ex) {
                Debug.debugException(ex);
            }
        }
        return Collections.unmodifiableMap(m);
    }

    public Long getTotalCount() {
        return this.totalCount;
    }

    public Map<String, Long> getTotalCountsByOID() {
        return this.totalCountsByOID;
    }

    public Long getFailedCount() {
        return this.failedCount;
    }

    public Map<String, Long> getFailedCountsByOID() {
        return this.failedCountsByOID;
    }

    public Double getFailedPercent() {
        return this.failedPercent;
    }

    public Map<String, Double> getFailedPercentsByOID() {
        return this.failedPercentsByOID;
    }

    public Map<String, Map<Integer, ResultCodeInfo>> getResultCodeInfoMap() {
        return this.resultCodeInfoMap;
    }

    public Map<String, String> getExtendedRequestNamesByOID() {
        return this.requestNamesByOID;
    }
}

