/*
 * Copyright (c) 2008, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package com.sun.ts.tests.jpa.core.annotations.version;

import javax.persistence.*;
import java.sql.Timestamp;

@Entity
@Table(name = "A_BASIC")
public class Timestamp_Property implements java.io.Serializable {

  protected String id;

  protected Timestamp basicTimestamp;

  protected String name;

  public Timestamp_Property() {
  }

  public Timestamp_Property(String id) {
    this.id = id;
  }

  public Timestamp_Property(String id, Timestamp basicTimestamp) {

    this.id = id;
    this.basicTimestamp = basicTimestamp;
  }

  @Id
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  @Basic
  public String getName() {
    return this.name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @Version
  public Timestamp getBasicTimestamp() {
    return this.basicTimestamp;
  }

  public void setBasicTimestamp(Timestamp basicTimestamp) {
    this.basicTimestamp = basicTimestamp;
  }

  public boolean equals(Object o) {
    Timestamp_Property other;
    boolean result = false;

    if (!(o instanceof Integer_Field)) {
      return result;
    }
    other = (Timestamp_Property) o;

    if (this.getId().equals(other.getId())
        && this.basicTimestamp.equals(other.basicTimestamp)
        && this.name.equals(other.getName())) {
      result = true;
    }

    return result;
  }

  public int hashCode() {
    int myHash;

    myHash = this.getId().hashCode() + this.basicTimestamp.hashCode()
        + this.name.hashCode();

    return myHash;
  }

  @Override
  public String toString() {
    StringBuilder result = new StringBuilder();
    result.append(this.getClass().getSimpleName() + "[");
    result.append("id: " + getId());
    result.append(", version: " + basicTimestamp);
    result.append(", name: " + name);
    result.append("]");
    return result.toString();
  }
}
