/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.framework.signature;

import ee.jakarta.tck.data.framework.signature.ApiCheckDriver;
import ee.jakarta.tck.data.framework.signature.SigTestDriver;
import ee.jakarta.tck.data.framework.signature.SignatureTestDriver;

public class SignatureTestDriverFactory {
    public static final String API_CHECK = "apicheck";
    public static final String SIG_TEST = "sigtest";

    private SignatureTestDriverFactory() {
    }

    public static SignatureTestDriver getInstance(String type) {
        if (type == null || type.length() == 0) {
            throw new IllegalArgumentException("Type was null or empty");
        }
        if (API_CHECK.equals(type)) {
            return new ApiCheckDriver();
        }
        if (SIG_TEST.equals(type)) {
            return new SigTestDriver();
        }
        throw new IllegalArgumentException("Unknown Type: '" + type + "'");
    }
}

