/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.test.spi;

import java.util.Collection;
import java.util.Map;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.container.spi.client.deployment.TargetDescription;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.test.api.Testable;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.GenericArchive;

public class TestDeployment {
    private DeploymentDescription deploymentDescription;
    private Archive<?> applicationArchive;
    private Collection<Archive<?>> auxiliaryArchives;
    private Archive<?> archiveForEnrichment;

    public TestDeployment(Archive<?> applicationArchive, Collection<Archive<?>> auxiliaryArchives) {
        this(null, applicationArchive, auxiliaryArchives);
    }

    public TestDeployment(DeploymentDescription deploymentDescription, Archive<?> applicationArchive, Collection<Archive<?>> auxiliaryArchives) {
        if (applicationArchive == null) {
            throw new IllegalArgumentException("ApplicationArchive must be specified");
        }
        if (auxiliaryArchives == null) {
            throw new IllegalArgumentException("AuxiliaryArchives must be specified");
        }
        this.deploymentDescription = deploymentDescription;
        this.applicationArchive = applicationArchive;
        this.auxiliaryArchives = auxiliaryArchives;
    }

    public TargetDescription getTargetDescription() {
        return this.deploymentDescription == null ? null : this.deploymentDescription.getTarget();
    }

    public ProtocolDescription getProtocolDescription() {
        return this.deploymentDescription == null ? null : this.deploymentDescription.getProtocol();
    }

    public String getDeploymentName() {
        return this.deploymentDescription == null ? null : this.deploymentDescription.getName();
    }

    public Archive<?> getArchiveForEnrichment() {
        if (this.archiveForEnrichment == null) {
            Map nested = this.applicationArchive.getContent(Filters.include((String)".*\\.war"));
            if (!nested.isEmpty()) {
                for (ArchivePath path : nested.keySet()) {
                    try {
                        GenericArchive genericArchive = (GenericArchive)this.applicationArchive.getAsType(GenericArchive.class, path);
                        if (!Testable.isArchiveToTest((Archive)genericArchive)) continue;
                        if (this.archiveForEnrichment != null) {
                            throw new UnsupportedOperationException("Multiple marked Archives found in " + this.applicationArchive.getName() + ". Can not determine which to enrich");
                        }
                        this.archiveForEnrichment = genericArchive;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
        } else {
            this.archiveForEnrichment = this.applicationArchive;
        }
        return this.archiveForEnrichment;
    }

    public Archive<?> getApplicationArchive() {
        return this.applicationArchive;
    }

    public Collection<Archive<?>> getAuxiliaryArchives() {
        return this.auxiliaryArchives;
    }
}

