/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.config.impl.extension;

import java.io.File;
import java.util.Properties;
import org.jboss.arquillian.config.impl.extension.PropertyResolver;

class PropertiesPropertyResolver
implements PropertyResolver {
    private static final String FILE_SEPARATOR = File.separator;
    private static final String PATH_SEPARATOR = File.pathSeparator;
    private static final String FILE_SEPARATOR_ALIAS = "/";
    private static final String PATH_SEPARATOR_ALIAS = ":";
    private final Properties props;

    PropertiesPropertyResolver(Properties props) {
        this.props = props;
    }

    @Override
    public String getValue(String key) {
        String value;
        if (FILE_SEPARATOR_ALIAS.equals(key)) {
            value = FILE_SEPARATOR;
        } else if (PATH_SEPARATOR_ALIAS.equals(key)) {
            value = PATH_SEPARATOR;
        } else {
            value = this.props != null ? this.props.getProperty(key) : System.getProperty(key);
            if (value == null) {
                int colon = key.indexOf(58);
                if (colon > 0) {
                    String realKey = key.substring(0, colon);
                    value = this.props != null ? this.props.getProperty(realKey) : System.getProperty(realKey);
                    if (value == null && (value = this.resolveCompositeKey(realKey, this.props)) == null) {
                        value = key.substring(colon + 1);
                    }
                } else {
                    value = this.resolveCompositeKey(key, this.props);
                }
            }
        }
        return value;
    }

    private String resolveCompositeKey(String key, Properties props) {
        String value = null;
        int comma = key.indexOf(44);
        if (comma > -1) {
            if (comma > 0) {
                String key1 = key.substring(0, comma);
                value = props != null ? props.getProperty(key1) : System.getProperty(key1);
            }
            if (value == null && comma < key.length() - 1) {
                String key2 = key.substring(comma + 1);
                value = props != null ? props.getProperty(key2) : System.getProperty(key2);
            }
        }
        return value;
    }
}

