/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.xmlconfiguration;

import jakarta.validation.ClockProvider;
import jakarta.validation.Configuration;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.constraints.Past;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.User;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.XmlDefinedClockProvider;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class ClockProviderSpecifiedInValidationXmlTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)ClockProviderSpecifiedInValidationXmlTest.webArchiveBuilder().withTestClass(ClockProviderSpecifiedInValidationXmlTest.class)).withClasses(XmlDefinedClockProvider.class)).withValidationXml("validation-ClockProviderSpecifiedInValidationXmlTest.xml")).build();
    }

    @Test
    @SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="j")
    public void testClockProviderSpecifiedInValidationXml() throws Exception {
        Assert.assertTrue((boolean)(TestUtil.getValidatorFactoryUnderTest().getClockProvider() instanceof XmlDefinedClockProvider), (String)"Clock provider configured in XML wasn't applied");
    }

    @SpecAssertions(value={@SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="d"), @SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="j")})
    public void testClockProviderSpecifiedInValidationXmlCanBeOverridden() {
        Configuration configuration = Validation.byDefaultProvider().configure();
        configuration = configuration.clockProvider((ClockProvider)new ConfigurationDefinedClockProvider());
        Validator validator = configuration.buildValidatorFactory().getValidator();
        User user = new User();
        user.setBirthday(ZonedDateTime.of(1980, 11, 10, 9, 16, 0, 0, ZoneId.of("Europe/Paris")));
        Set constraintViolations = validator.validate((Object)user, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Past.class));
    }

    private static class ConfigurationDefinedClockProvider
    implements ClockProvider {
        private ConfigurationDefinedClockProvider() {
        }

        public Clock getClock() {
            return Clock.fixed(Instant.parse("1980-11-08T10:15:30.00Z"), ZoneId.of("Europe/Paris"));
        }
    }
}

