/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.error.ShouldHaveValue;
import org.assertj.core.error.ShouldNotContainValue;

public class AtomicReferenceAssert<V>
extends AbstractAssert<AtomicReferenceAssert<V>, AtomicReference<V>> {
    public AtomicReferenceAssert(AtomicReference<V> actual) {
        super(actual, AtomicReferenceAssert.class);
    }

    public AtomicReferenceAssert<V> hasValue(V expectedValue) {
        this.isNotNull();
        Object actualValue = ((AtomicReference)this.actual).get();
        if (!this.objects.getComparisonStrategy().areEqual(actualValue, expectedValue)) {
            this.throwAssertionError(ShouldHaveValue.shouldHaveValue(this.actual, expectedValue));
        }
        return (AtomicReferenceAssert)this.myself;
    }

    public AtomicReferenceAssert<V> doesNotHaveValue(V expectedValue) {
        this.isNotNull();
        Object actualValue = ((AtomicReference)this.actual).get();
        if (this.objects.getComparisonStrategy().areEqual(actualValue, expectedValue)) {
            this.throwAssertionError(ShouldNotContainValue.shouldNotContainValue(this.actual, expectedValue));
        }
        return (AtomicReferenceAssert)this.myself;
    }
}

