/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.valueextraction.definition.model;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import org.hibernate.beanvalidation.tck.tests.valueextraction.definition.model.Order;

@Target(value={ElementType.TYPE_USE})
@Constraint(validatedBy={Validator.class})
@Documented
@Retention(value=RetentionPolicy.RUNTIME)
public @interface RetailOrder {
    public String message() default "not a valid retail order";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class Validator
    implements ConstraintValidator<RetailOrder, Order> {
        public boolean isValid(Order order, ConstraintValidatorContext constraintValidatorContext) {
            if (order == null || order.getId() == null) {
                return true;
            }
            return order.getId().startsWith("RETAIL-");
        }
    }
}

