/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.util.sec.misc;

import com.sun.ts.lib.util.sec.misc.Launcher;
import com.sun.ts.lib.util.sec.security.util.SecurityConstants;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.PropertyPermission;

class PathPermissions
extends PermissionCollection {
    private static final long serialVersionUID = 8133287259134945693L;
    private File[] path;
    private Permissions perms;
    URL codeBase;

    PathPermissions(File[] path) {
        this.path = path;
        this.perms = null;
        this.codeBase = null;
    }

    URL getCodeBase() {
        return this.codeBase;
    }

    @Override
    public void add(Permission permission) {
        throw new SecurityException("attempt to add a permission");
    }

    private synchronized void init() {
        if (this.perms != null) {
            return;
        }
        this.perms = new Permissions();
        this.perms.add(SecurityConstants.CREATE_CLASSLOADER_PERMISSION);
        this.perms.add(new PropertyPermission("java.*", "read"));
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (int i = 0; i < PathPermissions.this.path.length; ++i) {
                    String path;
                    File f = PathPermissions.this.path[i];
                    try {
                        path = f.getCanonicalPath();
                    }
                    catch (IOException ioe) {
                        path = f.getAbsolutePath();
                    }
                    if (i == 0) {
                        PathPermissions.this.codeBase = Launcher.getFileURL(new File(path));
                    }
                    if (f.isDirectory()) {
                        if (path.endsWith(File.separator)) {
                            PathPermissions.this.perms.add(new FilePermission(path + "-", "read"));
                            continue;
                        }
                        PathPermissions.this.perms.add(new FilePermission(path + File.separator + "-", "read"));
                        continue;
                    }
                    int endIndex = path.lastIndexOf(File.separatorChar);
                    if (endIndex == -1) continue;
                    path = path.substring(0, endIndex + 1) + "-";
                    PathPermissions.this.perms.add(new FilePermission(path, "read"));
                }
                return null;
            }
        });
    }

    @Override
    public boolean implies(Permission permission) {
        if (this.perms == null) {
            this.init();
        }
        return this.perms.implies(permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration elements() {
        if (this.perms == null) {
            this.init();
        }
        Permissions permissions = this.perms;
        synchronized (permissions) {
            return this.perms.elements();
        }
    }

    @Override
    public String toString() {
        if (this.perms == null) {
            this.init();
        }
        return this.perms.toString();
    }
}

