/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.model;

import com.sun.tdk.signaturetest.model.MemberDescription;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class AnnotationItem
implements Comparable {
    public static final String ANNOTATION_PREFIX = "anno";
    public static final String ANNOTATION_INHERITED = "java.lang.annotation.Inherited";
    public static final String ANNOTATION_DOCUMENTED = "java.lang.annotation.Documented";
    public static final AnnotationItem[] EMPTY_ANNOTATIONITEM_ARRAY = new AnnotationItem[0];
    private int target;
    private boolean inheritable = false;
    private String name;
    private SortedSet members = null;

    public AnnotationItem(int target, String name) {
        this.setTarget(target);
        this.setName(name);
    }

    public AnnotationItem() {
    }

    public int compareTo(Object o) {
        AnnotationItem that = (AnnotationItem)o;
        int diff = this.getSpecificData().compareTo(that.getSpecificData());
        if (diff == 0 && (diff = this.name.compareTo(that.name)) == 0) {
            if (this.members == that.members) {
                return 0;
            }
            if (this.members == null) {
                return -1;
            }
            if (that.members == null) {
                return 1;
            }
            diff = this.members.size() - that.members.size();
            if (diff == 0) {
                Iterator it = this.members.iterator();
                Iterator that_it = that.members.iterator();
                while (it.hasNext() && diff == 0) {
                    Member m = (Member)it.next();
                    diff = m.compareTo(that_it.next());
                }
            }
        }
        return diff;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationItem other = (AnnotationItem)obj;
        return this.compareTo(other) == 0;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + this.target;
        hash = 79 * hash + (this.inheritable ? 1 : 0);
        hash = 79 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 79 * hash + (this.members != null ? this.members.hashCode() : 0);
        return hash;
    }

    protected Set getMembers() {
        return this.members;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.intern();
    }

    public int getTarget() {
        return this.target;
    }

    public void setTarget(int t) {
        this.target = t;
    }

    public void addMember(Member m) {
        if (this.members == null) {
            this.members = new TreeSet();
        }
        this.members.add(m);
    }

    public boolean isInheritable() {
        return this.inheritable;
    }

    public void removeMember(Member m) {
        this.members.remove(m);
    }

    public static boolean isInternal(String annoName) {
        if (annoName.startsWith("sun.")) {
            return true;
        }
        if (annoName.startsWith("jdk.")) {
            return true;
        }
        return annoName.contains(".internal.");
    }

    public Member findByName(String name) {
        if (this.members != null) {
            for (Member m : this.members) {
                if (!m.name.equals(name)) continue;
                return m;
            }
        }
        return null;
    }

    protected String getSpecificData() {
        return "" + this.target;
    }

    protected String getPrefix() {
        return ANNOTATION_PREFIX;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getPrefix()).append(" ");
        if (!"".equals(this.getSpecificData())) {
            sb.append(this.getSpecificData()).append(" ");
        }
        sb.append(this.name).append('(');
        int i = 0;
        if (this.members != null) {
            for (Member m : this.members) {
                if (i++ != 0) {
                    sb.append(", ");
                }
                sb.append(m.type).append(' ').append(m.name).append("=");
                sb.append(m.value);
            }
        }
        sb.append(')');
        return sb.toString();
    }

    public void setInheritable(boolean inh) {
        this.inheritable = inh;
    }

    public static AnnotationItem[] toArray(List alist) {
        if (alist == null || alist.size() == 0) {
            return EMPTY_ANNOTATIONITEM_ARRAY;
        }
        int asize = alist.size();
        AnnotationItem[] tmp = new AnnotationItem[asize];
        for (int i = 0; i < asize; ++i) {
            tmp[i] = (AnnotationItem)alist.get(i);
        }
        return tmp;
    }

    public static class Member
    implements Comparable {
        public String type;
        public String name;
        public String value;

        public Member(String type, String name, Object value) {
            this.type = type;
            this.name = name;
            this.setValue(value);
        }

        public Member(String name, Object value) {
            this.name = name;
            this.setValue(value);
        }

        public Member() {
        }

        public int compareTo(Object x) {
            Member that = (Member)x;
            int result = 0;
            if (this.type != null && that.type != null) {
                result = this.type.compareTo(that.type);
            } else if (this.type != that.type) {
                result = this.type == null ? -1 : 1;
            }
            if (result == 0 && (result = this.name.compareTo(that.name)) == 0) {
                result = this.value.compareTo(that.value);
            }
            return result;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setValue(Object value) {
            this.value = value == null ? null : MemberDescription.valueToString(value);
        }
    }

    public static class ValueWrap {
        String value;

        public ValueWrap(String s) {
            this.value = s;
        }

        public String toString() {
            return this.value;
        }
    }
}

