/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class IntentParserUtil {
    public static final String EXPREG_ALL_BUT_OPEN = "([^{\\r\\n]*)";
    public static final String EXPREG_BACKSLASH = "\\";
    public static final String EXPREG_AT_LEAST_ONE_SPACE = "\\s+";
    public static final String EXPREG_MANY_SPACES = "\\s*";
    public static final String EXPREG_OPEN_SECTION = "Section\\s+([^{\\r\\n]*)\\{";
    public static final String EXPREG_OPEN_CHAPTER = "Chapter\\s+([^{\\r\\n]*)\\{";
    public static final String EXPREG_OPEN_DOCUMENT = "Document\\s*\\{";
    private static final String[] ENDING_DESCRIPTION_UNIT_TOKENS = new String[]{"\\}", "Document\\s*\\{", "Chapter\\s+([^{\\r\\n]*)\\{", "\\s*@M\\s*", "Section\\s+([^{\\r\\n]*)\\{"};
    private static final String[] FLOW_BREAKING_TOKENS = new String[]{"}", "{", "@M", "M@"};

    private IntentParserUtil() {
    }

    public static String[] getEndingDescriptionUnitTokens() {
        return ENDING_DESCRIPTION_UNIT_TOKENS;
    }

    public static int getNextOffset(String currentlyParsedContent) {
        Integer[] possibleNextOffsets = new Integer[FLOW_BREAKING_TOKENS.length];
        int i = 0;
        while (i < FLOW_BREAKING_TOKENS.length) {
            possibleNextOffsets[i] = currentlyParsedContent.indexOf(FLOW_BREAKING_TOKENS[i]);
            if (possibleNextOffsets[i] > -1) {
                int n = i;
                possibleNextOffsets[n] = possibleNextOffsets[n] + FLOW_BREAKING_TOKENS[i].length();
            }
            ++i;
        }
        return IntentParserUtil.getNextOffSetInTable(possibleNextOffsets);
    }

    private static int getNextOffSetInTable(Integer[] possibleNextOffsets) {
        int nextOffset = -1;
        int i = 0;
        while (i < possibleNextOffsets.length) {
            if (possibleNextOffsets[i] > -1 && (nextOffset == -1 || possibleNextOffsets[i] < nextOffset)) {
                nextOffset = possibleNextOffsets[i];
            }
            ++i;
        }
        return nextOffset;
    }

    public static String getDescriptionUnitContainedInText(String text, boolean trim) {
        String returnedDescriptionUnit = text;
        String[] stringArray = ENDING_DESCRIPTION_UNIT_TOKENS;
        int n = ENDING_DESCRIPTION_UNIT_TOKENS.length;
        int n2 = 0;
        while (n2 < n) {
            String endingDescriptionUnitKeyword = stringArray[n2];
            Pattern ptr = Pattern.compile(endingDescriptionUnitKeyword);
            Matcher matcher = ptr.matcher(returnedDescriptionUnit);
            if (matcher.find()) {
                returnedDescriptionUnit = returnedDescriptionUnit.substring(0, matcher.start());
                if (trim) {
                    returnedDescriptionUnit = returnedDescriptionUnit.trim();
                }
            }
            ++n2;
        }
        return String.valueOf(returnedDescriptionUnit) + "\n";
    }
}

