/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.jboss.logmanager.ExtLogRecord;

public abstract class ExtFormatter
extends Formatter {
    public static ExtFormatter wrap(Formatter formatter, boolean formatMessages) {
        if (formatter instanceof ExtFormatter && !formatMessages) {
            return (ExtFormatter)formatter;
        }
        return new WrappedFormatter(formatter, formatMessages);
    }

    @Override
    public final String format(LogRecord record) {
        return this.format(ExtLogRecord.wrap(record));
    }

    public abstract String format(ExtLogRecord var1);

    @Override
    public String formatMessage(LogRecord record) {
        Object[] parameters;
        ResourceBundle bundle2 = record.getResourceBundle();
        String msg = record.getMessage();
        if (msg == null) {
            return null;
        }
        if (bundle2 != null) {
            try {
                msg = bundle2.getString(msg);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if ((parameters = record.getParameters()) == null || parameters.length == 0) {
            return this.formatMessageNone(record);
        }
        if (record instanceof ExtLogRecord) {
            ExtLogRecord extLogRecord = (ExtLogRecord)record;
            ExtLogRecord.FormatStyle formatStyle = extLogRecord.getFormatStyle();
            if (formatStyle == ExtLogRecord.FormatStyle.PRINTF) {
                return this.formatMessagePrintf(record);
            }
            if (formatStyle == ExtLogRecord.FormatStyle.NO_FORMAT) {
                return this.formatMessageNone(record);
            }
        }
        return msg.indexOf(123) >= 0 ? this.formatMessageLegacy(record) : this.formatMessageNone(record);
    }

    public boolean isCallerCalculationRequired() {
        return true;
    }

    protected String formatMessageNone(LogRecord record) {
        return record.getMessage();
    }

    protected String formatMessageLegacy(LogRecord record) {
        return MessageFormat.format(record.getMessage(), record.getParameters());
    }

    protected String formatMessagePrintf(LogRecord record) {
        return String.format(record.getMessage(), record.getParameters());
    }

    static class WrappedFormatter
    extends ExtFormatter {
        private final Formatter formatter;
        private final boolean formatMessages;

        WrappedFormatter(Formatter formatter, boolean formatMessages) {
            this.formatter = formatter;
            this.formatMessages = formatMessages;
        }

        @Override
        public String format(ExtLogRecord record) {
            return this.formatter.format(record);
        }

        @Override
        public String formatMessage(LogRecord record) {
            return this.formatMessages ? super.formatMessage(record) : this.formatter.formatMessage(record);
        }

        @Override
        public String getHead(Handler h) {
            return this.formatter.getHead(h);
        }

        @Override
        public String getTail(Handler h) {
            return this.formatter.getTail(h);
        }
    }

    public static abstract class Delegating
    extends ExtFormatter {
        protected final ExtFormatter delegate;

        public Delegating(ExtFormatter delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate");
        }

        @Override
        public String format(ExtLogRecord record) {
            return this.delegate.format(record);
        }

        @Override
        public String formatMessage(LogRecord record) {
            return this.delegate.formatMessage(record);
        }

        @Override
        public boolean isCallerCalculationRequired() {
            return this.delegate.isCallerCalculationRequired();
        }

        @Override
        public String getHead(Handler h) {
            return this.delegate.getHead(h);
        }

        @Override
        public String getTail(Handler h) {
            return this.delegate.getTail(h);
        }
    }
}

