/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.dns;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.mutiny.core.dns.MxRecord;
import io.vertx.mutiny.core.dns.SrvRecord;
import java.util.List;
import java.util.stream.Collectors;

@MutinyGen(value=io.vertx.core.dns.DnsClient.class)
public class DnsClient {
    public static final TypeArg<DnsClient> __TYPE_ARG = new TypeArg<DnsClient>(obj -> new DnsClient((io.vertx.core.dns.DnsClient)obj), DnsClient::getDelegate);
    private final io.vertx.core.dns.DnsClient delegate;

    public DnsClient(io.vertx.core.dns.DnsClient delegate) {
        this.delegate = delegate;
    }

    public DnsClient(Object delegate) {
        this.delegate = (io.vertx.core.dns.DnsClient)delegate;
    }

    DnsClient() {
        this.delegate = null;
    }

    public io.vertx.core.dns.DnsClient getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DnsClient that = (DnsClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @CheckReturnValue
    public Uni<String> lookup(String name) {
        return AsyncResultUni.toUni(handler -> this.delegate.lookup(name, (Handler<AsyncResult<String>>)handler));
    }

    public String lookupAndAwait(String name) {
        return this.lookup(name).await().indefinitely();
    }

    @Fluent
    public DnsClient lookupAndForget(String name) {
        this.lookup(name).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<String> lookup4(String name) {
        return AsyncResultUni.toUni(handler -> this.delegate.lookup4(name, (Handler<AsyncResult<String>>)handler));
    }

    public String lookup4AndAwait(String name) {
        return this.lookup4(name).await().indefinitely();
    }

    @Fluent
    public DnsClient lookup4AndForget(String name) {
        this.lookup4(name).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<String> lookup6(String name) {
        return AsyncResultUni.toUni(handler -> this.delegate.lookup6(name, (Handler<AsyncResult<String>>)handler));
    }

    public String lookup6AndAwait(String name) {
        return this.lookup6(name).await().indefinitely();
    }

    @Fluent
    public DnsClient lookup6AndForget(String name) {
        this.lookup6(name).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<List<String>> resolveA(String name) {
        return AsyncResultUni.toUni(handler -> this.delegate.resolveA(name, (Handler<AsyncResult<List<String>>>)handler));
    }

    public List<String> resolveAAndAwait(String name) {
        return this.resolveA(name).await().indefinitely();
    }

    @Fluent
    public DnsClient resolveAAndForget(String name) {
        this.resolveA(name).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<List<String>> resolveAAAA(String name) {
        return AsyncResultUni.toUni(handler -> this.delegate.resolveAAAA(name, (Handler<AsyncResult<List<String>>>)handler));
    }

    public List<String> resolveAAAAAndAwait(String name) {
        return this.resolveAAAA(name).await().indefinitely();
    }

    @Fluent
    public DnsClient resolveAAAAAndForget(String name) {
        this.resolveAAAA(name).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<List<String>> resolveCNAME(String name) {
        return AsyncResultUni.toUni(handler -> this.delegate.resolveCNAME(name, (Handler<AsyncResult<List<String>>>)handler));
    }

    public List<String> resolveCNAMEAndAwait(String name) {
        return this.resolveCNAME(name).await().indefinitely();
    }

    @Fluent
    public DnsClient resolveCNAMEAndForget(String name) {
        this.resolveCNAME(name).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<List<MxRecord>> resolveMX(String name) {
        return AsyncResultUni.toUni(handler -> this.delegate.resolveMX(name, new DelegatingHandler<AsyncResult, AsyncResult>((Handler<AsyncResult>)handler, ar -> ar.map(event -> event.stream().map(elt -> MxRecord.newInstance(elt)).collect(Collectors.toList())))));
    }

    public List<MxRecord> resolveMXAndAwait(String name) {
        return this.resolveMX(name).await().indefinitely();
    }

    @Fluent
    public DnsClient resolveMXAndForget(String name) {
        this.resolveMX(name).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<List<String>> resolveTXT(String name) {
        return AsyncResultUni.toUni(handler -> this.delegate.resolveTXT(name, (Handler<AsyncResult<List<String>>>)handler));
    }

    public List<String> resolveTXTAndAwait(String name) {
        return this.resolveTXT(name).await().indefinitely();
    }

    @Fluent
    public DnsClient resolveTXTAndForget(String name) {
        this.resolveTXT(name).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<String> resolvePTR(String name) {
        return AsyncResultUni.toUni(handler -> this.delegate.resolvePTR(name, (Handler<AsyncResult<String>>)handler));
    }

    public String resolvePTRAndAwait(String name) {
        return this.resolvePTR(name).await().indefinitely();
    }

    @Fluent
    public DnsClient resolvePTRAndForget(String name) {
        this.resolvePTR(name).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<List<String>> resolveNS(String name) {
        return AsyncResultUni.toUni(handler -> this.delegate.resolveNS(name, (Handler<AsyncResult<List<String>>>)handler));
    }

    public List<String> resolveNSAndAwait(String name) {
        return this.resolveNS(name).await().indefinitely();
    }

    @Fluent
    public DnsClient resolveNSAndForget(String name) {
        this.resolveNS(name).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<List<SrvRecord>> resolveSRV(String name) {
        return AsyncResultUni.toUni(handler -> this.delegate.resolveSRV(name, new DelegatingHandler<AsyncResult, AsyncResult>((Handler<AsyncResult>)handler, ar -> ar.map(event -> event.stream().map(elt -> SrvRecord.newInstance(elt)).collect(Collectors.toList())))));
    }

    public List<SrvRecord> resolveSRVAndAwait(String name) {
        return this.resolveSRV(name).await().indefinitely();
    }

    @Fluent
    public DnsClient resolveSRVAndForget(String name) {
        this.resolveSRV(name).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<String> reverseLookup(String ipaddress) {
        return AsyncResultUni.toUni(handler -> this.delegate.reverseLookup(ipaddress, (Handler<AsyncResult<String>>)handler));
    }

    public String reverseLookupAndAwait(String ipaddress) {
        return this.reverseLookup(ipaddress).await().indefinitely();
    }

    @Fluent
    public DnsClient reverseLookupAndForget(String ipaddress) {
        this.reverseLookup(ipaddress).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.delegate.close((Handler<AsyncResult<Void>>)handler));
    }

    public Void closeAndAwait() {
        return this.close().await().indefinitely();
    }

    public void closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
    }

    public static DnsClient newInstance(io.vertx.core.dns.DnsClient arg) {
        return arg != null ? new DnsClient(arg) : null;
    }
}

