/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.netty.handler.codec.http.QueryStringDecoder;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.impl.HttpServerRequestInternal;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.AllowForwardHeaders;
import io.vertx.ext.web.impl.ForwardedParser;
import io.vertx.ext.web.impl.ServerWebSocketWrapper;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;

class HttpServerRequestWrapper
extends io.vertx.core.http.impl.HttpServerRequestWrapper {
    private final ForwardedParser forwardedParser;
    private boolean modified;
    private HttpMethod method;
    private String path;
    private String query;
    private String uri;
    private String absoluteURI;
    private MultiMap params;

    HttpServerRequestWrapper(HttpServerRequest request, AllowForwardHeaders allowForward) {
        super((HttpServerRequestInternal)request);
        this.forwardedParser = new ForwardedParser(request, allowForward);
    }

    void changeTo(HttpMethod method, String uri) {
        this.modified = true;
        this.method = method;
        this.uri = uri;
        this.query = null;
        this.absoluteURI = null;
        int queryIndex = uri.indexOf(63);
        if (queryIndex != -1) {
            int fragmentIndex = uri.indexOf(35, queryIndex);
            this.path = uri.substring(0, queryIndex);
            this.query = fragmentIndex != -1 ? uri.substring(queryIndex + 1, fragmentIndex) : uri.substring(queryIndex + 1);
        } else {
            int fragmentIndex = uri.indexOf(35);
            this.path = fragmentIndex != -1 ? uri.substring(0, fragmentIndex) : uri;
        }
    }

    @Override
    public HttpMethod method() {
        if (!this.modified) {
            return this.delegate.method();
        }
        return this.method;
    }

    @Override
    public String uri() {
        if (!this.modified) {
            return this.delegate.uri();
        }
        return this.uri;
    }

    @Override
    public String path() {
        if (!this.modified) {
            return this.delegate.path();
        }
        return this.path;
    }

    @Override
    public String query() {
        if (!this.modified) {
            return this.delegate.query();
        }
        return this.query;
    }

    @Override
    public MultiMap params() {
        if (!this.modified) {
            return this.delegate.params();
        }
        if (this.params == null) {
            QueryStringDecoder queryStringDecoder;
            Map<String, List<String>> prms;
            this.params = MultiMap.caseInsensitiveMultiMap();
            if (this.query != null && !(prms = (queryStringDecoder = new QueryStringDecoder(this.uri, Charset.forName(this.delegate.getParamsCharset()))).parameters()).isEmpty()) {
                for (Map.Entry<String, List<String>> entry : prms.entrySet()) {
                    this.params.add(entry.getKey(), (Iterable<String>)entry.getValue());
                }
            }
        }
        return this.params;
    }

    @Override
    public String getParam(String param) {
        if (!this.modified) {
            return this.delegate.getParam(param);
        }
        return this.params().get(param);
    }

    @Override
    public HttpServerRequest setParamsCharset(String s) {
        String old = this.delegate.getParamsCharset();
        this.delegate.setParamsCharset(s);
        if (!s.equals(old)) {
            this.params = null;
        }
        return this;
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.forwardedParser.remoteAddress();
    }

    @Override
    public String absoluteURI() {
        if (!this.modified) {
            return this.forwardedParser.absoluteURI();
        }
        if (this.absoluteURI == null) {
            String scheme = this.forwardedParser.scheme();
            String host = this.forwardedParser.host();
            this.absoluteURI = scheme != null && host != null ? scheme + "://" + host + this.uri : this.uri;
        }
        return this.absoluteURI;
    }

    @Override
    public String scheme() {
        return this.forwardedParser.scheme();
    }

    @Override
    public String host() {
        return this.forwardedParser.host();
    }

    @Override
    public void toWebSocket(Handler<AsyncResult<ServerWebSocket>> handler) {
        this.delegate.toWebSocket(toWebSocket -> {
            if (toWebSocket.succeeded()) {
                handler.handle(Future.succeededFuture(new ServerWebSocketWrapper((ServerWebSocket)toWebSocket.result(), this.host(), this.scheme(), this.isSSL(), this.remoteAddress())));
            } else {
                handler.handle((AsyncResult<ServerWebSocket>)toWebSocket);
            }
        });
    }

    @Override
    public Future<ServerWebSocket> toWebSocket() {
        return this.delegate.toWebSocket().map(ws -> new ServerWebSocketWrapper((ServerWebSocket)ws, this.host(), this.scheme(), this.isSSL(), this.remoteAddress()));
    }

    @Override
    public boolean isSSL() {
        return this.forwardedParser.isSSL();
    }
}

