/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.inject;

import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.inject.MetadataInjectionPoint;
import io.smallrye.config.inject.SecuritySupport;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.config.ConfigProvider;

public class ConfigMappingInjectionBean<T>
implements Bean<T> {
    private final BeanManager bm;
    private final ConfigMappings.ConfigClassWithPrefix configClassWithPrefix;

    public ConfigMappingInjectionBean(ConfigMappings.ConfigClassWithPrefix configClassWithPrefix, BeanManager bm) {
        this.bm = bm;
        this.configClassWithPrefix = configClassWithPrefix;
    }

    @Override
    public Class<T> getBeanClass() {
        return this.configClassWithPrefix.getKlass();
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        ConfigMapping configMapping;
        InjectionPoint injectionPoint = (InjectionPoint)this.bm.getInjectableReference(new MetadataInjectionPoint(), creationalContext);
        String prefix = this.configClassWithPrefix.getPrefix();
        if (injectionPoint != null && injectionPoint.getAnnotated() != null && (configMapping = injectionPoint.getAnnotated().getAnnotation(ConfigMapping.class)) != null) {
            prefix = configMapping.prefix();
        }
        SmallRyeConfig config = ConfigProvider.getConfig(SecuritySupport.getContextClassLoader()).unwrap(SmallRyeConfig.class);
        return config.getConfigMapping(this.getBeanClass(), prefix);
    }

    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
    }

    @Override
    public Set<Type> getTypes() {
        return Collections.singleton(this.configClassWithPrefix.getKlass());
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return Collections.singleton(Default.Literal.INSTANCE);
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName() + "_" + this.configClassWithPrefix.getKlass().getName();
    }

    @Override
    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    @Override
    public boolean isAlternative() {
        return false;
    }
}

