/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.kafka.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.kafka.KafkaClientMetrics;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.lang.NonNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Producer;
import org.eclipse.hono.client.kafka.metrics.KafkaClientMetricsSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MicrometerKafkaClientMetricsSupport
implements KafkaClientMetricsSupport {
    public static final List<String> DEFAULT_METRICS_PREFIXES = List.of("kafka.producer.topic.record.send.rate", "kafka.producer.topic.record.error.rate", "kafka.producer.node.request.rate", "kafka.producer.node.response.rate", "kafka.producer.node.request.latency.avg", "kafka.producer.node.outgoing.byte.rate", "kafka.producer.io.wait.time.ns.avg", "kafka.producer.batch.size.avg", "kafka.producer.produce.throttle.time.avg", "kafka.producer.produce.throttle.time.max", "kafka.consumer.fetch.manager.records.lag", "kafka.consumer.fetch.manager.records.lag.max", "kafka.consumer.fetch.manager.records.lead.min", "kafka.consumer.fetch.manager.bytes.consumed.rate", "kafka.consumer.fetch.manager.records.consumed.rate", "kafka.consumer.fetch.manager.fetch.rate", "kafka.consumer.fetch.manager.fetch.throttle.time.avg", "kafka.consumer.fetch.manager.fetch.throttle.time.max", "kafka.consumer.coordinator.rebalance.total", "kafka.consumer.coordinator.failed.rebalance.total", "kafka.consumer.coordinator.rebalance.latency.avg");
    private static final Logger LOG = LoggerFactory.getLogger(MicrometerKafkaClientMetricsSupport.class);
    private static final String PREFIX_KAFKA = "kafka.";
    private final List<MeterRegistry> boundMeterRegistries = new ArrayList<MeterRegistry>();
    private final Map<Producer<?, ?>, KafkaClientMetrics> producerMetricsMap = new HashMap();
    private final Map<Consumer<?, ?>, KafkaClientMetrics> consumerMetricsMap = new HashMap();
    private final boolean producerMetricsEnabled;
    private final boolean consumerMetricsEnabled;
    private final List<String> metricsPrefixesToUse;

    public MicrometerKafkaClientMetricsSupport(boolean useDefaultMetrics, List<String> metricsPrefixes) {
        Objects.requireNonNull(metricsPrefixes);
        this.metricsPrefixesToUse = new ArrayList<String>(useDefaultMetrics ? DEFAULT_METRICS_PREFIXES : List.of());
        metricsPrefixes.stream().map(String::trim).filter(p -> p.startsWith(PREFIX_KAFKA)).forEach(this.metricsPrefixesToUse::add);
        boolean reportAllMetrics = MicrometerKafkaClientMetricsSupport.isReportAllMetrics(this.metricsPrefixesToUse);
        this.producerMetricsEnabled = reportAllMetrics || this.metricsPrefixesToUse.stream().anyMatch(prefix -> "kafka.producer".startsWith((String)prefix) || prefix.startsWith("kafka.producer"));
        boolean bl = this.consumerMetricsEnabled = reportAllMetrics || this.metricsPrefixesToUse.stream().anyMatch(prefix -> "kafka.consumer".startsWith((String)prefix) || prefix.startsWith("kafka.consumer"));
        if (!this.producerMetricsEnabled && !this.consumerMetricsEnabled) {
            LOG.info("Kafka client metrics are disabled (defaults not used and metrics list empty or without matching entries); given metrics prefixes: {}", (Object)metricsPrefixes);
        }
    }

    private static boolean isReportAllMetrics(List<String> metricsPrefixes) {
        return metricsPrefixes.contains("kafka") || metricsPrefixes.contains(PREFIX_KAFKA);
    }

    public boolean isProducerMetricsEnabled() {
        return this.producerMetricsEnabled;
    }

    public boolean isConsumerMetricsEnabled() {
        return this.consumerMetricsEnabled;
    }

    @Override
    public synchronized void registerKafkaProducer(Producer<?, ?> producer) {
        KafkaClientMetrics kafkaClientMetrics;
        Objects.requireNonNull(producer);
        if (this.producerMetricsEnabled && !this.producerMetricsMap.containsKey(producer) && this.producerMetricsMap.putIfAbsent(producer, kafkaClientMetrics = new KafkaClientMetrics(producer)) == null) {
            this.boundMeterRegistries.forEach(x$0 -> kafkaClientMetrics.bindTo((MeterRegistry)x$0));
            LOG.debug("registered producer ({} producers total)", (Object)this.producerMetricsMap.size());
        }
    }

    @Override
    public synchronized void registerKafkaConsumer(Consumer<?, ?> consumer) {
        KafkaClientMetrics kafkaClientMetrics;
        Objects.requireNonNull(consumer);
        if (this.consumerMetricsEnabled && !this.consumerMetricsMap.containsKey(consumer) && this.consumerMetricsMap.putIfAbsent(consumer, kafkaClientMetrics = new KafkaClientMetrics(consumer)) == null) {
            this.boundMeterRegistries.forEach(x$0 -> kafkaClientMetrics.bindTo((MeterRegistry)x$0));
            LOG.debug("registered consumer ({} consumers total)", (Object)this.consumerMetricsMap.size());
        }
    }

    @Override
    public synchronized void unregisterKafkaProducer(Producer<?, ?> producer) {
        Objects.requireNonNull(producer);
        Optional.ofNullable(this.producerMetricsMap.remove(producer)).ifPresent(rec$ -> ((KafkaClientMetrics)rec$).close());
    }

    @Override
    public synchronized void unregisterKafkaConsumer(Consumer<?, ?> consumer) {
        Objects.requireNonNull(consumer);
        Optional.ofNullable(this.consumerMetricsMap.remove(consumer)).ifPresent(rec$ -> ((KafkaClientMetrics)rec$).close());
    }

    @Override
    public synchronized void bindTo(@NonNull MeterRegistry registry) {
        if (this.producerMetricsEnabled || this.consumerMetricsEnabled) {
            if (MicrometerKafkaClientMetricsSupport.isReportAllMetrics(this.metricsPrefixesToUse)) {
                LOG.info("activating Kafka client metrics support; all metrics will be reported - consider configuring individual metrics to reduce the number of reported metrics");
            } else {
                LOG.info("activating Kafka client metrics support; used metrics prefixes: {}", (Object)this.metricsPrefixesToUse);
                registry.config().meterFilter(MeterFilter.accept(id -> this.metricsPrefixesToUse.stream().anyMatch(prefix -> id.getName().startsWith((String)prefix))));
                registry.config().meterFilter(MeterFilter.denyNameStartsWith(PREFIX_KAFKA));
            }
            this.consumerMetricsMap.values().forEach(kafkaClientMetrics -> kafkaClientMetrics.bindTo(registry));
            this.producerMetricsMap.values().forEach(kafkaClientMetrics -> kafkaClientMetrics.bindTo(registry));
            this.boundMeterRegistries.add(registry);
        }
    }
}

