/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.hawk.core.IVcsManager;
import org.eclipse.hawk.core.VcsCommit;
import org.eclipse.hawk.core.VcsCommitItem;

public class VcsRepositoryDelta
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected IVcsManager vcsManager;
    protected final Iterable<VcsCommit> commits;
    protected String latestRevision;

    public VcsRepositoryDelta(Iterable<VcsCommit> commits) {
        this.commits = commits;
    }

    public IVcsManager getManager() {
        return this.vcsManager;
    }

    public void setManager(IVcsManager manager) {
        this.vcsManager = manager;
    }

    public Iterable<VcsCommit> getCommits() {
        return () -> {
            final Iterator<VcsCommit> itCommits = this.commits.iterator();
            return new Iterator<VcsCommit>(){

                @Override
                public boolean hasNext() {
                    return itCommits.hasNext();
                }

                @Override
                public VcsCommit next() {
                    VcsCommit commit = (VcsCommit)itCommits.next();
                    commit.setDelta(VcsRepositoryDelta.this);
                    return commit;
                }
            };
        };
    }

    public int size() {
        int count = 0;
        Iterator<VcsCommit> it = this.commits.iterator();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    public List<VcsCommitItem> getCompactedCommitItems() {
        LinkedHashMap<String, VcsCommitItem> compacted = new LinkedHashMap<String, VcsCommitItem>();
        for (VcsCommit commit : this.commits) {
            commit.setDelta(this);
            for (VcsCommitItem item : commit.getItems()) {
                switch (item.getChangeType()) {
                    case ADDED: 
                    case DELETED: 
                    case UPDATED: 
                    case REPLACED: {
                        compacted.put(item.getPath(), item);
                        break;
                    }
                    case UNKNOWN: {
                        System.err.println("Found unknnown commit kind: " + (Object)((Object)item.getChangeType()));
                    }
                }
            }
        }
        return new ArrayList<VcsCommitItem>(compacted.values());
    }
}

