/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ClosedProjectFilter
extends ViewerFilter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof ILaunchConfigurationType) {
            return true;
        }
        if (!(element instanceof ILaunchConfiguration)) return false;
        try {
            ILaunchConfiguration config = (ILaunchConfiguration)element;
            IResource[] resources = config.getMappedResources();
            if (resources == null) {
                return true;
            }
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource resource = iResourceArray[n2];
                IProject project = resource.getProject();
                if (project != null) {
                    if (project.isOpen()) return true;
                    if (!project.exists()) {
                        return true;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }
}

