/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.emf;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.hawk.core.model.IHawkAttribute;
import org.eclipse.hawk.core.model.IHawkClass;
import org.eclipse.hawk.core.model.IHawkClassifier;
import org.eclipse.hawk.core.model.IHawkDataType;
import org.eclipse.hawk.core.model.IHawkObject;
import org.eclipse.hawk.core.model.IHawkReference;
import org.eclipse.hawk.core.model.IHawkStructuralFeature;
import org.eclipse.hawk.emf.EMFWrapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMFObject
implements IHawkObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(EMFObject.class);
    protected EMFWrapperFactory wf;
    protected EObject eob;
    private byte[] signature;

    public EMFObject(EObject o, EMFWrapperFactory wf) {
        this.eob = o;
        this.wf = wf;
    }

    public EObject getEObject() {
        return this.eob;
    }

    public boolean isInDifferentResourceThan(IHawkObject o) {
        if (o instanceof EMFObject) {
            EMFObject otherR = (EMFObject)o;
            return this.eob.eIsProxy() || otherR.eob.eResource() != this.eob.eResource();
        }
        return false;
    }

    public String getUri() {
        return EcoreUtil.getURI((EObject)this.eob).toString();
    }

    public String getUriFragment() {
        URI uri = null;
        try {
            uri = EcoreUtil.getURI((EObject)this.eob);
            String frag = uri.fragment();
            return frag;
        }
        catch (Exception e) {
            LOGGER.error("For object:{}\nwithin: {}\nof type:{}\nCould not find URI {}, returning null", new Object[]{this.eob, this.eob.eResource(), this.eob.eClass(), uri});
            return null;
        }
    }

    public boolean isFragmentUnique() {
        return false;
    }

    public IHawkClassifier getType() {
        return this.wf.createClass(this.eob.eClass());
    }

    public boolean isSet(IHawkStructuralFeature hsf) {
        EStructuralFeature sf = this.eob.eClass().getEStructuralFeature(hsf.getName());
        return this.eob.eIsSet(sf) || sf.getDefaultValue() != null;
    }

    public Object get(IHawkAttribute attribute) {
        Object ret = this.eob.eGet(this.eob.eClass().getEStructuralFeature(attribute.getName()));
        if (ret instanceof FeatureMap) {
            LinkedList<Object> subset = new LinkedList<Object>();
            FeatureMap.ValueListIterator it = ((FeatureMap)ret).valueListIterator();
            while (it.hasNext()) {
                Object next = it.next();
                if (next instanceof EObject) continue;
                subset.add(next);
            }
            return subset;
        }
        return ret;
    }

    public Object get(IHawkReference reference, boolean resolve) {
        Object ret;
        Object source = this.eob.eGet(this.eob.eClass().getEStructuralFeature(reference.getName()), resolve);
        if (source instanceof Iterable) {
            ret = new LinkedList();
            if (source instanceof FeatureMap) {
                FeatureMap.ValueListIterator it = ((FeatureMap)source).valueListIterator();
                while (it.hasNext()) {
                    Object next = it.next();
                    if (!(next instanceof EObject)) continue;
                    ((LinkedList)ret).add(this.wf.createObject((EObject)next));
                }
            } else {
                for (EObject e : (Iterable)source) {
                    ((LinkedList)ret).add(this.wf.createObject(e));
                }
            }
        } else {
            ret = this.wf.createObject((EObject)source);
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (o instanceof EMFObject) {
            return this.eob.equals(((EMFObject)o).getEObject());
        }
        return false;
    }

    public int hashCode() {
        return this.eob.hashCode();
    }

    public String toString() {
        String ret = "";
        ret = String.valueOf(ret) + "> " + this.eob + " :::with attributes::: ";
        for (EAttribute e : this.eob.eClass().getEAllAttributes()) {
            ret = String.valueOf(ret) + e + " : " + this.eob.eGet((EStructuralFeature)e);
        }
        ret = String.valueOf(ret);
        return ret;
    }

    public boolean isRoot() {
        return this.eob.eContainer() == null;
    }

    public boolean URIIsRelative() {
        return EcoreUtil.getURI((EObject)this.eob).isRelative();
    }

    public byte[] signature() {
        if (this.signature == null) {
            if (this.eob.eIsProxy()) {
                LOGGER.error("Signature called on proxy object returning null");
                return null;
            }
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                LOGGER.error("signature() tried to create a SHA-1 digest but a NoSuchAlgorithmException was thrown, returning null", (Throwable)e);
                return null;
            }
            md.update(this.getUri().getBytes());
            md.update(this.getUriFragment().getBytes());
            IHawkClassifier type = this.getType();
            md.update(type.getName().getBytes());
            md.update(type.getPackageNSURI().getBytes());
            if (!(type instanceof IHawkDataType)) {
                if (type instanceof IHawkClass) {
                    for (IHawkAttribute eAttribute : ((IHawkClass)type).getAllAttributes()) {
                        if (!eAttribute.isDerived() && !this.isSet((IHawkStructuralFeature)eAttribute)) continue;
                        md.update(eAttribute.getName().getBytes());
                        if (eAttribute.isDerived()) continue;
                        md.update(this.get(eAttribute).toString().getBytes());
                    }
                    for (IHawkReference eRef : ((IHawkClass)type).getAllReferences()) {
                        if (!this.isSet((IHawkStructuralFeature)eRef)) continue;
                        md.update(eRef.getName().getBytes());
                        Object destinationObjects = this.get(eRef, false);
                        if (destinationObjects instanceof Iterable) {
                            for (IHawkObject o : (Iterable)destinationObjects) {
                                md.update(o.getUriFragment().getBytes());
                            }
                            continue;
                        }
                        md.update(((IHawkObject)destinationObjects).getUriFragment().getBytes());
                    }
                } else {
                    LOGGER.warn("Unknown type {} while creating signature", (Object)type);
                }
            }
            this.signature = md.digest();
        }
        return this.signature;
    }
}

