/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.ui2.util;

import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.osgiserver.HManager;
import org.eclipse.hawk.osgiserver.HModel;
import org.eclipse.hawk.ui2.view.HView;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;

public class HUIManager
extends HManager
implements IStructuredContentProvider,
IWorkbenchListener {
    private static HUIManager inst;

    public static synchronized HUIManager getInstance() {
        if (inst == null) {
            inst = new HUIManager();
            if (PlatformUI.isWorkbenchRunning()) {
                PlatformUI.getWorkbench().addWorkbenchListener((IWorkbenchListener)inst);
            } else {
                System.err.println("No workbench is open: running without a workbench listener.\nPlease ensure preShutdown is called before shutting down this application!");
            }
        }
        return inst;
    }

    protected HUIManager() {
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public boolean preShutdown(IWorkbench workbench, boolean forced) {
        System.out.println("(PRE SHUTDOWN) Shutting down Hawk");
        HUIManager.getInstance().stopAllRunningInstances(IModelIndexer.ShutdownRequestType.ONLY_LOCAL);
        return true;
    }

    public void postShutdown(IWorkbench workbench) {
        System.out.println("(POST SHUTDOWN) Hawk shut down");
    }

    protected void stateChanged(HModel m) {
        if (PlatformUI.isWorkbenchRunning()) {
            HView.updateAsync(PlatformUI.getWorkbench().getDisplay());
        }
    }

    protected void infoChanged(HModel m) {
        if (PlatformUI.isWorkbenchRunning()) {
            HView.updateAsync(PlatformUI.getWorkbench().getDisplay());
        }
    }
}

