/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.ui.providers.marker;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.services.marker.AbstractMarkerNavigationProvider;
import org.eclipse.gmf.runtime.emf.ui.internal.MslUIDebugOptions;
import org.eclipse.gmf.runtime.emf.ui.internal.MslUIPlugin;
import org.eclipse.ui.IEditorPart;

public abstract class AbstractModelMarkerNavigationProvider
extends AbstractMarkerNavigationProvider {
    private TransactionalEditingDomain editingDomain;

    public final void gotoMarker(final IEditorPart editor, final IMarker marker) {
        EditingDomain domain;
        this.setEditor(editor);
        IEditingDomainProvider domainProvider = (IEditingDomainProvider)this.getEditor().getAdapter(IEditingDomainProvider.class);
        if (domainProvider != null && (domain = domainProvider.getEditingDomain()) instanceof TransactionalEditingDomain) {
            this.editingDomain = (TransactionalEditingDomain)domain;
        }
        if (this.editingDomain != null) {
            try {
                this.editingDomain.runExclusive(new Runnable(){

                    public void run() {
                        AbstractModelMarkerNavigationProvider.super.gotoMarker(editor, marker);
                    }
                });
            }
            catch (InterruptedException e) {
                Trace.catching((Plugin)MslUIPlugin.getDefault(), (String)MslUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"gotoMarker", (Throwable)e);
                Log.error((Plugin)MslUIPlugin.getDefault(), (int)10, (String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    protected Resource getResource(IMarker marker) {
        IPath resourcePath;
        Resource result = null;
        if (marker.exists() && (resourcePath = marker.getResource().getLocation()) != null) {
            ResourceSet resourceSet = this.editingDomain.getResourceSet();
            URI uri = URI.createFileURI((String)resourcePath.toOSString());
            result = resourceSet.getResource(uri, true);
        }
        return result;
    }

    protected List getEObjects(List ids, Resource resource) {
        ArrayList<EObject> result = new ArrayList<EObject>(ids.size());
        URI resourceUri = resource.getURI();
        ResourceSet rset = resource.getResourceSet();
        if (rset != null) {
            for (String nextId : ids) {
                URI nextUri;
                int hashPos = nextId.indexOf(35);
                if (hashPos <= 0) {
                    nextUri = resourceUri.appendFragment(nextId.substring(hashPos + 1));
                } else {
                    String resUriStr = nextId.substring(0, hashPos);
                    String elemIdStr = nextId.substring(hashPos + 1);
                    try {
                        resUriStr = URLDecoder.decode(resUriStr, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    nextUri = URI.createURI((String)resUriStr).appendFragment(elemIdStr);
                }
                try {
                    EObject element = rset.getEObject(nextUri, true);
                    if (element == null) continue;
                    result.add(element);
                }
                catch (WrappedException wrappedException) {}
            }
        }
        return result;
    }
}

