/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.icon;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.common.ui.services.icon.GetIconOperation;
import org.eclipse.gmf.runtime.common.ui.services.icon.IIconProvider;
import org.eclipse.gmf.runtime.common.ui.services.icon.IconOptions;
import org.eclipse.gmf.runtime.common.ui.services.internal.CommonUIServicesPlugin;
import org.eclipse.gmf.runtime.common.ui.services.internal.icon.IconServiceProviderConfiguration;
import org.eclipse.swt.graphics.Image;

public class IconService
extends Service
implements IIconProvider {
    private static final IconService _instance = new IconService();

    private IconService() {
        this.configureProviders(CommonUIServicesPlugin.getPluginId(), "iconProviders");
    }

    public static IconService getInstance() {
        return _instance;
    }

    public Image getIcon(IAdaptable hint, int flags) {
        return (Image)this.executeUnique(ExecutionStrategy.FIRST, new GetIconOperation(hint, flags));
    }

    public Image getIcon(IAdaptable hint) {
        return this.getIcon(hint, IconOptions.NONE.intValue());
    }

    protected Service.ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        return new ProviderDescriptor(element);
    }

    protected static class ProviderDescriptor
    extends Service.ProviderDescriptor {
        private IconServiceProviderConfiguration providerConfiguration;

        public ProviderDescriptor(IConfigurationElement element) {
            super(element);
            this.providerConfiguration = IconServiceProviderConfiguration.parse(element);
        }

        public boolean provides(IOperation operation) {
            if (!this.policyInitialized) {
                this.policy = this.getPolicy();
                this.policyInitialized = true;
            }
            if (this.policy != null) {
                return this.policy.provides(operation);
            }
            if (this.provider == null) {
                if (this.isSupportedInExtention(operation)) {
                    this.providerConfiguration = null;
                    IProvider theProvider = this.getProvider();
                    return theProvider != null ? theProvider.provides(operation) : false;
                }
                return false;
            }
            IProvider theProvider = this.getProvider();
            return theProvider != null ? theProvider.provides(operation) : false;
        }

        private boolean isSupportedInExtention(IOperation operation) {
            if (operation instanceof GetIconOperation && this.providerConfiguration != null) {
                GetIconOperation o = (GetIconOperation)operation;
                return this.providerConfiguration.supports(o.getHint());
            }
            return false;
        }
    }
}

