/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.gmodel;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.command.Command;
import org.eclipse.glsp.graph.GEdge;
import org.eclipse.glsp.graph.GModelIndex;
import org.eclipse.glsp.graph.GPoint;
import org.eclipse.glsp.graph.util.GraphUtil;
import org.eclipse.glsp.server.operations.ChangeRoutingPointsOperation;
import org.eclipse.glsp.server.operations.GModelOperationHandler;
import org.eclipse.glsp.server.types.ElementAndRoutingPoints;
import org.eclipse.glsp.server.utils.LayoutUtil;

public class GModelChangeRoutingPointsHandler
extends GModelOperationHandler<ChangeRoutingPointsOperation> {
    @Override
    public Optional<Command> createCommand(ChangeRoutingPointsOperation operation) {
        List<ElementAndRoutingPoints> changedRoutingPoints = operation.getNewRoutingPoints().stream().filter(this::hasChanged).toList();
        return changedRoutingPoints.isEmpty() ? GModelChangeRoutingPointsHandler.doNothing() : this.commandOf(() -> this.executeChangeRoutingPoints(new ChangeRoutingPointsOperation(changedRoutingPoints)));
    }

    protected boolean hasChanged(ElementAndRoutingPoints routingPoints) {
        Optional edge = this.modelState.getIndex().getByClass(routingPoints.getElementId(), GEdge.class);
        if (edge.isEmpty() || ((GEdge)edge.get()).getRoutingPoints().size() != routingPoints.getNewRoutingPoints().size()) {
            return true;
        }
        return !Arrays.equals((GPoint[])((GEdge)edge.get()).getRoutingPoints().toArray((Object[])new GPoint[0]), routingPoints.getNewRoutingPoints().toArray(new GPoint[0]), GraphUtil::compare);
    }

    protected void executeChangeRoutingPoints(ChangeRoutingPointsOperation operation) {
        GModelIndex index = this.modelState.getIndex();
        operation.getNewRoutingPoints().forEach(routingPoints -> {
            GEdge gEdge = LayoutUtil.applyRoutingPoints(routingPoints, index);
        });
    }
}

