/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.websocket;

import com.google.inject.Module;
import java.net.InetSocketAddress;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import org.eclipse.glsp.server.di.ServerModule;
import org.eclipse.glsp.server.launch.GLSPServerLauncher;
import org.eclipse.glsp.server.websocket.GLSPConfigurator;
import org.eclipse.glsp.server.websocket.GLSPServerEndpoint;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.websocket.javax.server.config.JavaxWebSocketServletContainerInitializer;

public class WebsocketServerLauncher
extends GLSPServerLauncher {
    public static final String START_UP_COMPLETE_MSG = "[GLSP-Server]:Startup completed. Accepting requests on port:";
    protected static Logger LOGGER = LogManager.getLogger(WebsocketServerLauncher.class);
    protected Server server;
    protected final String endpointPath;
    protected final Level websocketLogLevel;

    public WebsocketServerLauncher(ServerModule serverModule, String endpointPath, Module ... additionalModules) {
        this(serverModule, endpointPath, Level.INFO, additionalModules);
    }

    public WebsocketServerLauncher(ServerModule serverModule, String endpointPath, Level websocketLogLevel, Module ... additionalModules) {
        super(serverModule, additionalModules);
        this.endpointPath = endpointPath.startsWith("/") ? endpointPath.substring(1) : endpointPath;
        this.websocketLogLevel = websocketLogLevel;
    }

    protected String getStartupCompleteMessage() {
        return START_UP_COMPLETE_MSG;
    }

    public void start(String hostname, int port) {
        try {
            Configurator.setLevel((String)"org.eclipse.jetty", (Level)this.websocketLogLevel);
            this.server = new Server(new InetSocketAddress(hostname, port));
            ServletContextHandler webAppContext = new ServletContextHandler(1);
            webAppContext.setContextPath("/");
            JavaxWebSocketServletContainerInitializer.configure((ServletContextHandler)webAppContext, (servletContext, wsContainer) -> {
                ServerEndpointConfig.Builder builder = ServerEndpointConfig.Builder.create(GLSPServerEndpoint.class, (String)("/" + this.endpointPath));
                builder.configurator((ServerEndpointConfig.Configurator)new GLSPConfigurator(() -> ((WebsocketServerLauncher)this).createInjector()));
                wsContainer.setDefaultMaxSessionIdleTimeout(-1L);
                wsContainer.addEndpoint(builder.build());
            });
            this.server.setHandler((Handler)webAppContext);
            try {
                this.server.start();
                if (port == 0) {
                    port = this.server.getURI().getPort();
                }
                LOGGER.info("GLSP server is running and listening on Endpoint : " + this.server.getURI() + this.endpointPath);
                System.out.println(String.valueOf(this.getStartupCompleteMessage()) + port);
                this.server.join();
            }
            catch (Exception exception) {
                LOGGER.warn("Shutting down due to exception", (Throwable)exception);
                System.exit(1);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to start Websocket GLSP server " + ex.getMessage(), (Throwable)ex);
        }
    }

    public void shutdown() {
        if (this.server.isRunning()) {
            try {
                this.server.stop();
            }
            catch (Exception ex) {
                LOGGER.error("Failed to stop Websocket GLSP server " + ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

