/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.emf.notation;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.glsp.server.emf.AbstractEMFOperationHandler;
import org.eclipse.glsp.server.emf.model.notation.NotationPackage;
import org.eclipse.glsp.server.emf.model.notation.Shape;
import org.eclipse.glsp.server.emf.notation.EMFNotationModelState;
import org.eclipse.glsp.server.operations.ChangeBoundsOperation;
import org.eclipse.glsp.server.types.ElementAndBounds;

public class EMFChangeBoundsOperationHandler
extends AbstractEMFOperationHandler<ChangeBoundsOperation> {
    @Inject
    protected EMFNotationModelState modelState;

    @Override
    public Optional<Command> createCommand(ChangeBoundsOperation operation) {
        EditingDomain editingDomain = this.modelState.getEditingDomain();
        CompoundCommand compoundCommand = new CompoundCommand();
        for (ElementAndBounds element : operation.getNewBounds()) {
            this.modelState.getIndex().getNotation(element.getElementId(), Shape.class).map(shape -> this.updateShape(editingDomain, (Shape)shape, element)).ifPresent(commands -> commands.forEach(arg_0 -> ((CompoundCommand)compoundCommand).append(arg_0)));
        }
        return compoundCommand.getCommandList().isEmpty() ? Optional.empty() : Optional.of(compoundCommand);
    }

    private List<Command> updateShape(EditingDomain editingDomain, Shape shape, ElementAndBounds elementAndBounds) {
        ArrayList<Command> commands = new ArrayList<Command>();
        if (elementAndBounds.getNewPosition() != null) {
            Command setPosCommand = SetCommand.create((EditingDomain)editingDomain, (Object)shape, (Object)NotationPackage.Literals.SHAPE__POSITION, (Object)EcoreUtil.copy((EObject)elementAndBounds.getNewPosition()));
            commands.add(setPosCommand);
        }
        if (elementAndBounds.getNewSize() != null) {
            Command setSizeCommand = SetCommand.create((EditingDomain)editingDomain, (Object)shape, (Object)NotationPackage.Literals.SHAPE__SIZE, (Object)EcoreUtil.copy((EObject)elementAndBounds.getNewSize()));
            commands.add(setSizeCommand);
        }
        return commands;
    }
}

