/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.actions;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.ActionMessage;

public interface ActionDispatcher {
    default public CompletableFuture<Void> dispatch(ActionMessage message) {
        return this.dispatch(message.getClientId(), message.getAction());
    }

    public CompletableFuture<Void> dispatch(String var1, Action var2);

    default public List<CompletableFuture<Void>> dispatchAll(String clientId, List<Action> actions) {
        return actions.stream().map(action -> this.dispatch(clientId, (Action)action)).collect(Collectors.toList());
    }

    public static class NullImpl
    implements ActionDispatcher {
        @Override
        public CompletableFuture<Void> dispatch(String clientId, Action action) {
            return CompletableFuture.completedFuture(null);
        }
    }
}

