/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.CNonceCacheFactory;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.security.common.CNonceCache;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class CNonceCacheFactoryImpl
implements CNonceCacheFactory,
PostConstruct {
    @Inject
    @Named(value="HA-CNonceCache")
    private Provider<CNonceCache> cHANonceCacheProvider;
    @Inject
    @Named(value="CNonceCache")
    private Provider<CNonceCache> cNonceCacheProvider;
    @Inject
    @Named(value="default-instance-name")
    private SecurityService secService;
    protected long cnonceCacheSize = 1000L;
    protected long nonceValidity = 300000L;

    public void postConstruct() {
        String sz = this.secService.getPropertyValue("NONCE_CACHE_SIZE");
        String age = this.secService.getPropertyValue("MAX_NONCE_AGE");
        if (sz != null) {
            this.cnonceCacheSize = Long.parseLong(sz);
        }
        if (age != null) {
            this.nonceValidity = Long.parseLong(age);
        }
    }

    public CNonceCache createCNonceCache(String appName, String clusterName, String instanceName, String storeName) {
        boolean haEnabled = clusterName != null && instanceName != null && storeName != null;
        CNonceCache cache = null;
        HashMap<String, String> map = new HashMap<String, String>();
        if (haEnabled) {
            cache = this.cHANonceCacheProvider.get();
            map.put("cluster_name", clusterName);
            map.put("instance_name", instanceName);
        } else {
            cache = this.cNonceCacheProvider.get();
        }
        if (cache != null) {
            cache.init(this.cnonceCacheSize, storeName, this.nonceValidity, map);
        }
        return cache;
    }
}

