/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.module.bootstrap.EarlyLogHandler;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.glassfish.grizzly.config.dom.Http;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.Protocols;
import org.glassfish.hk2.api.PostConstruct;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service
public class AdminRESTConfigUpgrade
implements ConfigurationUpgrade,
PostConstruct {
    @Inject
    Configs configs;
    @Inject
    @Named(value="grizzlyconfigupgrade")
    @Optional
    ConfigurationUpgrade precondition = null;

    public void postConstruct() {
        for (Config config : this.configs.getConfig()) {
            block7: {
                try {
                    if (config.getAdminListener() == null) {
                        LogRecord lr = new LogRecord(Level.FINE, String.format("Skipping config %s. No admin listener.", config.getName()));
                        lr.setLoggerName(this.getClass().getName());
                        EarlyLogHandler.earlyMessages.add(lr);
                    }
                    break block7;
                }
                catch (IllegalStateException ise) {
                    LogRecord lr = new LogRecord(Level.FINE, String.format("Skipping config %s. getAdminListener threw: %s", config.getName(), ise.getLocalizedMessage()));
                    lr.setLoggerName(this.getClass().getName());
                    EarlyLogHandler.earlyMessages.add(lr);
                }
                continue;
            }
            Protocols ps = config.getNetworkConfig().getProtocols();
            if (ps == null) continue;
            for (Protocol p : ps.getProtocol()) {
                Http h = p.getHttp();
                if (h == null || !"__asadmin".equals(h.getDefaultVirtualServer())) continue;
                try {
                    ConfigSupport.apply(new HttpConfigCode(), h);
                }
                catch (TransactionFailure tf) {
                    LogRecord lr = new LogRecord(Level.SEVERE, "Could not upgrade http element for admin console: " + tf);
                    lr.setLoggerName(this.getClass().getName());
                    EarlyLogHandler.earlyMessages.add(lr);
                }
            }
        }
    }

    private static class HttpConfigCode
    implements SingleConfigCode<Http> {
        private HttpConfigCode() {
        }

        @Override
        public Object run(Http http) throws PropertyVetoException, TransactionFailure {
            http.setEncodedSlashEnabled("true");
            return null;
        }
    }
}

