/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.validator;

import com.sun.webui.jsf.component.DateManager;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import java.text.MessageFormat;
import java.util.Date;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class DateInRangeValidator
implements Validator {
    public static final String VALIDATOR_ID = "com.sun.webui.jsf.DateInRange";
    private static final boolean DEBUG = false;

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!(value instanceof Date)) {
            return;
        }
        DateManager dateManager = null;
        if (component instanceof DateManager) {
            dateManager = (DateManager)component;
        } else if (component.getParent() instanceof DateManager) {
            dateManager = (DateManager)component.getParent();
        }
        if (dateManager == null) {
            return;
        }
        Date date = (Date)value;
        Date minDate = dateManager.getFirstAvailableDate();
        if (minDate != null && date.before(minDate)) {
            FacesMessage msg = this.getFacesMessage(component, context, minDate, "DateInRangeValidator.after");
            throw new ValidatorException(msg);
        }
        Date maxDate = dateManager.getLastAvailableDate();
        if (maxDate != null && maxDate.before(date)) {
            FacesMessage msg = this.getFacesMessage(component, context, maxDate, "DateInRangeValidator.before");
            throw new ValidatorException(msg);
        }
    }

    private FacesMessage getFacesMessage(UIComponent component, FacesContext context, Date date, String key) {
        String message = ThemeUtilities.getTheme(context).getMessage(key);
        String arg = ConversionUtilities.convertValueToString(component, date);
        MessageFormat mf = new MessageFormat(message, context.getViewRoot().getLocale());
        Object[] params = new Object[]{arg};
        return new FacesMessage(mf.format(params));
    }

    private void log(String s) {
        System.out.println(this.getClass().getName() + "::" + s);
    }
}

