/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Head;
import com.sun.webui.jsf.component.util.Util;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletResponse;

public class HeadRenderer
extends AbstractRenderer {
    private static final String[] stringAttributes = new String[]{"profile"};
    private static final String DATE_ONE = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US).format(new Date(1L));

    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (!RenderingUtilities.isPortlet(context)) {
            writer.startElement("head", component);
        }
    }

    protected void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Head head = (Head)component;
        if (!RenderingUtilities.isPortlet(context)) {
            String title;
            HeadRenderer.addStringAttributes(context, component, writer, stringAttributes);
            if (head.isMeta()) {
                writer.write("\n");
                HttpServletResponse servletResponse = (HttpServletResponse)context.getCurrentInstance().getExternalContext().getResponse();
                servletResponse.setHeader("Pragma", "no-cache");
                servletResponse.setHeader("Cache-Control", "no-store");
                servletResponse.setHeader("Cache-Control", "no-cache");
                servletResponse.setHeader("Expires", DATE_ONE);
                servletResponse.setHeader("X-Frame-Options", "SAMEORIGIN");
                this.renderMetaTag("no-cache", "Pragma", writer, head);
                this.renderMetaTag("no-cache", "Cache-Control", writer, head);
                this.renderMetaTag("no-store", "Cache-Control", writer, head);
                this.renderMetaTag("max-age=0", "Cache-Control", writer, head);
                this.renderMetaTag("1", "Expires", writer, head);
            }
            if ((title = head.getTitle()) == null) {
                title = "";
            }
            writer.startElement("title", (UIComponent)head);
            writer.write(title);
            writer.endElement("title");
            writer.write("\n");
            if (head.isDefaultBase()) {
                writer.startElement("base", (UIComponent)head);
                writer.writeURIAttribute("href", (Object)Util.getBase(context), null);
                writer.endElement("base");
                writer.write("\n");
            }
            Theme theme = ThemeUtilities.getTheme(context);
            RenderingUtilities.renderStyleSheetLink((UIComponent)head, theme, context, writer);
            if (!head.isJavaScript()) {
                return;
            }
            JavaScriptUtilities.renderJavaScript(component, writer, JavaScriptUtilities.getDojoConfig(head.isDebug(), head.isParseWidgets()));
            JavaScriptUtilities.renderDojoInclude(component, writer);
            JavaScriptUtilities.renderJsonInclude(component, writer);
            JavaScriptUtilities.renderPrototypeInclude(component, writer);
            JavaScriptUtilities.renderJsfxInclude(component, writer);
            JavaScriptUtilities.renderJavaScript(component, writer, JavaScriptUtilities.getModuleConfig(head.isDebug()));
            JavaScriptUtilities.renderGlobalInclude(component, writer);
        }
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (!RenderingUtilities.isPortlet(context)) {
            writer.endElement("head");
            writer.write("\n");
        }
    }

    private void renderMetaTag(String content, String httpEquivalent, ResponseWriter writer, Head head) throws IOException {
        writer.startElement("meta", (UIComponent)head);
        writer.writeAttribute("content", (Object)content, null);
        writer.writeAttribute("http-equiv", (Object)httpEquivalent, null);
        writer.endElement("meta");
        writer.writeText((Object)"\n", null);
    }
}

