/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.jmsclient.ConnectionConsumerImpl;
import com.sun.messaging.jmq.jmsclient.XAResourceImpl;
import com.sun.messaging.jmq.util.XidImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.transaction.xa.XAException;

public class XAResourceMap {
    private static final int DEFAULT_MAXROLLBACKS = 12;
    public static final int MAXROLLBACKS = XAResourceMap.getMAXROLLBACKS();
    private static final boolean DEFAULT_DMQ_ON_MAXROLLBACKS = false;
    public static final boolean DMQ_ON_MAXROLLBACKS = XAResourceMap.getDMQ_ON_MAXROLLBACKS();
    private static HashMap<XidImpl, Set<XAResourceImpl>> resourceMap = new HashMap();
    private static ArrayList<ConnectionConsumerImpl> unregisterListenerCC = new ArrayList();

    private static int getMAXROLLBACKS() {
        try {
            return Integer.parseInt(System.getProperty("imq.maxConsecutiveRollbacks", String.valueOf(12)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 12;
        }
    }

    private static boolean getDMQ_ON_MAXROLLBACKS() {
        return Boolean.valueOf(System.getProperty("imq.dmqOnMaxConsecutiveRollbacks", String.valueOf(false)));
    }

    public static synchronized void register(XidImpl xid, XAResourceImpl xar, boolean isJoin) throws XAException {
        Set<XAResourceImpl> resources = resourceMap.get(xid);
        if (resources == null) {
            if (isJoin) {
                XAException xae = new XAException("Trying to add an XAResource using the JOIN flag when no existing XAResource has been added with this XID");
                xae.errorCode = -5;
                throw xae;
            }
            resources = new HashSet<XAResourceImpl>();
            resourceMap.put(xid, resources);
        } else if (!isJoin) {
            XAException xae = new XAException("Trying to add an XAResource to an existing xid without using the JOIN flag");
            xae.errorCode = -8;
            throw xae;
        }
        resources.add(xar);
    }

    public static synchronized void unregister(XidImpl xid) {
        resourceMap.remove(xid);
        if (unregisterListenerCC.size() > 0) {
            Iterator<ConnectionConsumerImpl> itr = unregisterListenerCC.iterator();
            ConnectionConsumerImpl cc = null;
            while (itr.hasNext()) {
                cc = itr.next();
                cc.unregisteredXAResource();
            }
        }
    }

    public static synchronized void unregisterResource(XAResourceImpl xar, XidImpl xid) {
        Set<XAResourceImpl> resources;
        ConnectionConsumerImpl cc;
        if (unregisterListenerCC.size() > 0 && (cc = xar.getConnectionConsumer()) != null && unregisterListenerCC.contains(cc)) {
            cc.unregisteredXAResource();
        }
        if ((resources = resourceMap.get(xid)) != null) {
            resources.remove(xar);
            if (resources.size() == 0) {
                resourceMap.remove(xid);
            }
        }
    }

    public static synchronized XAResourceImpl[] getXAResources(XidImpl xid, boolean throwExceptionIfNotFound) throws XAException {
        Set<XAResourceImpl> resources = resourceMap.get(xid);
        if (resources == null) {
            if (throwExceptionIfNotFound) {
                XAException xae = new XAException("Unknown XID (was start() called?");
                throw xae;
            }
            return new XAResourceImpl[0];
        }
        return resources.toArray(new XAResourceImpl[resources.size()]);
    }

    public static boolean isEmpty() {
        return resourceMap.isEmpty();
    }

    public static int hasXAResourceForCC(ConnectionConsumerImpl cc) {
        return XAResourceMap.hasXAResourceForCC(cc, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static int hasXAResourceForCC(ConnectionConsumerImpl cc, boolean listen) {
        XidImpl[] keys = null;
        Class<XAResourceMap> clazz = XAResourceMap.class;
        // MONITORENTER : com.sun.messaging.jmq.jmsclient.XAResourceMap.class
        keys = resourceMap.keySet().toArray(new XidImpl[resourceMap.size()]);
        // MONITOREXIT : clazz
        ArrayList<XAResourceImpl> allxars = new ArrayList<XAResourceImpl>();
        Set<XAResourceImpl> xarss = null;
        for (int i = 0; i < keys.length; ++i) {
            Class<XAResourceMap> clazz2 = XAResourceMap.class;
            // MONITORENTER : com.sun.messaging.jmq.jmsclient.XAResourceMap.class
            xarss = resourceMap.get(keys[i]);
            if (xarss == null) {
                // MONITOREXIT : clazz2
                continue;
            }
            allxars.addAll(xarss);
            // MONITOREXIT : clazz2
        }
        XAResourceImpl[] xars = allxars.toArray(new XAResourceImpl[0]);
        int cnt = 0;
        XAResourceImpl xar = null;
        ConnectionConsumerImpl xcc = null;
        for (int i = 0; i < xars.length; ++i) {
            xar = xars[i];
            xcc = xar.getConnectionConsumer();
            if (xcc == null || xcc != cc) continue;
            ++cnt;
        }
        if (!listen) {
            return cnt;
        }
        if (cnt > 0) {
            XAResourceMap.addUnregisterListenerCC(cc);
            return cnt;
        }
        XAResourceMap.removeUnregisterListenerCC(cc);
        return cnt;
    }

    public static synchronized void addUnregisterListenerCC(ConnectionConsumerImpl cc) {
        unregisterListenerCC.add(cc);
    }

    public static synchronized void removeUnregisterListenerCC(ConnectionConsumerImpl cc) {
        unregisterListenerCC.remove(cc);
    }
}

