/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.AttributeVector;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassField;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassMethod;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstClass;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstantPool;
import com.sun.jdo.api.persistence.enhancer.classfile.VMConstants;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public final class ClassFile
implements VMConstants {
    public static final int magic = -889275714;
    public static final short[][] jdkMajorMinorVersions = new short[][]{{45, 3}, {46, 0}, {47, 0}, {48, 0}, {49, 0}, {50, 0}};
    public static final List jdkVersions = ClassFile.convertMajorMinorVersions(jdkMajorMinorVersions);
    public static final String supportedVersions = ClassFile.printSupportedVersions();
    private int majorVersion = 0;
    private int minorVersion = 0;
    private ConstantPool constantPool = new ConstantPool();
    private int accessFlags = 0;
    private ConstClass thisClassName;
    private ConstClass superClassName;
    private Vector classInterfaces = new Vector();
    private Vector classFields = new Vector();
    private Vector classMethods = new Vector();
    private AttributeVector classAttributes = new AttributeVector();

    public ConstantPool pool() {
        return this.constantPool;
    }

    public int access() {
        return this.accessFlags;
    }

    public final boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public final boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    public final boolean isPublic() {
        return (this.accessFlags & 1) != 0;
    }

    public final boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public void setAccessFlags(int flags) {
        this.accessFlags = flags;
    }

    public ConstClass className() {
        return this.thisClassName;
    }

    public ConstClass superName() {
        return this.superClassName;
    }

    public String superNameString() {
        return this.superClassName == null ? null : this.superClassName.asString();
    }

    public void setSuperName(ConstClass superCl) {
        this.superClassName = superCl;
    }

    public Vector interfaces() {
        return this.classInterfaces;
    }

    public void addInterface(ConstClass iface) {
        this.classInterfaces.addElement(iface);
    }

    public Vector fields() {
        return this.classFields;
    }

    public void addField(ClassField field) {
        this.classFields.addElement(field);
    }

    public void addField(ClassField field, int index) {
        this.classFields.insertElementAt(field, index);
    }

    public Vector methods() {
        return this.classMethods;
    }

    public ClassMethod findMethod(String methodName, String methodSig) {
        Enumeration e = this.methods().elements();
        while (e.hasMoreElements()) {
            ClassMethod method = (ClassMethod)e.nextElement();
            if (!method.name().asString().equals(methodName) || !method.signature().asString().equals(methodSig)) continue;
            return method;
        }
        return null;
    }

    public void addMethod(ClassMethod method) {
        this.classMethods.addElement(method);
    }

    public ClassField findField(String fieldName) {
        Enumeration e = this.fields().elements();
        while (e.hasMoreElements()) {
            ClassField field = (ClassField)e.nextElement();
            if (!field.name().asString().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public AttributeVector attributes() {
        return this.classAttributes;
    }

    public ClassFile(DataInputStream data) throws ClassFormatError {
        try {
            int thisMagic = data.readInt();
            if (thisMagic != -889275714) {
                throw new ClassFormatError("Bad magic value for input");
            }
            short thisMinorVersion = data.readShort();
            short thisMajorVersion = data.readShort();
            if (!ClassFile.isSupportedVersion(thisMajorVersion, thisMinorVersion)) {
                throw new ClassFormatError("Bad version number: {" + thisMajorVersion + "," + thisMinorVersion + "} expected one of: " + supportedVersions);
            }
            this.minorVersion = thisMinorVersion;
            this.majorVersion = thisMajorVersion;
            this.readConstants(data);
            this.accessFlags = data.readUnsignedShort();
            this.thisClassName = (ConstClass)this.constantPool.constantAt(data.readUnsignedShort());
            this.superClassName = (ConstClass)this.constantPool.constantAt(data.readUnsignedShort());
            this.readInterfaces(data);
            this.readFields(data);
            this.readMethods(data);
            this.classAttributes = AttributeVector.readAttributes(data, this.constantPool);
        }
        catch (IOException e) {
            ClassFormatError cfe = new ClassFormatError("IOException during reading");
            cfe.initCause(e);
            throw cfe;
        }
    }

    public ClassFile(String cname, String supername) {
        this.thisClassName = this.constantPool.addClass(cname);
        this.superClassName = this.constantPool.addClass(supername);
    }

    public void write(DataOutputStream buff) throws IOException {
        buff.writeInt(-889275714);
        buff.writeShort(this.minorVersion);
        buff.writeShort(this.majorVersion);
        this.constantPool.write(buff);
        buff.writeShort(this.accessFlags);
        buff.writeShort(this.thisClassName.getIndex());
        buff.writeShort(this.superClassName == null ? 0 : this.superClassName.getIndex());
        this.writeInterfaces(buff);
        this.writeFields(buff);
        this.writeMethods(buff);
        this.classAttributes.write(buff);
    }

    public byte[] getBytes() throws IOException {
        String writeClassToDirectory = System.getProperty("filter.writeClassToDirectory");
        if (writeClassToDirectory != null) {
            String filename = writeClassToDirectory + File.separator + this.thisClassName.asString() + ".class";
            System.err.println("Writing class to file " + filename);
            DataOutputStream stream = new DataOutputStream(new FileOutputStream(filename));
            this.write(stream);
            stream.close();
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        this.write(new DataOutputStream(byteStream));
        return byteStream.toByteArray();
    }

    public void print(PrintStream out) {
        int i;
        this.constantPool.print(out);
        out.println();
        out.println("majorVersion = " + Integer.toString(this.majorVersion));
        out.println("minorVersion = " + Integer.toString(this.minorVersion));
        out.println("accessFlags = " + Integer.toString(this.accessFlags));
        out.println("className = " + this.thisClassName.asString());
        out.println("superClassName = " + this.superClassName.asString());
        out.print("Interfaces =");
        for (i = 0; i < this.classInterfaces.size(); ++i) {
            out.print(" " + ((ConstClass)this.classInterfaces.elementAt(i)).asString());
        }
        out.println();
        out.println("fields =");
        for (i = 0; i < this.classFields.size(); ++i) {
            ((ClassField)this.classFields.elementAt(i)).print(out, 3);
        }
        out.println("methods =");
        for (i = 0; i < this.classMethods.size(); ++i) {
            ((ClassMethod)this.classMethods.elementAt(i)).print(out, 3);
        }
        out.println("attributes =");
        this.classAttributes.print(out, 3);
    }

    public void summarize() {
        PrintStream os = System.out;
        this.constantPool.summarize();
        int codeSize = 0;
        for (int i = 0; i < this.classMethods.size(); ++i) {
            codeSize += ((ClassMethod)this.classMethods.elementAt(i)).codeSize();
        }
        System.out.println(this.classMethods.size() + " methods in " + codeSize + " bytes");
    }

    private void readConstants(DataInputStream data) throws IOException {
        this.constantPool = new ConstantPool(data);
    }

    private void readInterfaces(DataInputStream data) throws IOException {
        int nInterfaces = data.readUnsignedShort();
        while (nInterfaces-- > 0) {
            int interfaceIndex = data.readUnsignedShort();
            ConstClass ci = null;
            if (interfaceIndex != 0) {
                ci = (ConstClass)this.constantPool.constantAt(interfaceIndex);
            }
            this.classInterfaces.addElement(ci);
        }
    }

    private void writeInterfaces(DataOutputStream data) throws IOException {
        data.writeShort(this.classInterfaces.size());
        for (int i = 0; i < this.classInterfaces.size(); ++i) {
            ConstClass ci = (ConstClass)this.classInterfaces.elementAt(i);
            int interfaceIndex = 0;
            if (ci != null) {
                interfaceIndex = ci.getIndex();
            }
            data.writeShort(interfaceIndex);
        }
    }

    private void readFields(DataInputStream data) throws IOException {
        int nFields = data.readUnsignedShort();
        while (nFields-- > 0) {
            this.classFields.addElement(ClassField.read(data, this.constantPool));
        }
    }

    private void writeFields(DataOutputStream data) throws IOException {
        data.writeShort(this.classFields.size());
        for (int i = 0; i < this.classFields.size(); ++i) {
            ((ClassField)this.classFields.elementAt(i)).write(data);
        }
    }

    private void readMethods(DataInputStream data) throws IOException {
        int nMethods = data.readUnsignedShort();
        while (nMethods-- > 0) {
            this.classMethods.addElement(ClassMethod.read(data, this.constantPool));
        }
    }

    private void writeMethods(DataOutputStream data) throws IOException {
        data.writeShort(this.classMethods.size());
        for (int i = 0; i < this.classMethods.size(); ++i) {
            ((ClassMethod)this.classMethods.elementAt(i)).write(data);
        }
    }

    private static List convertMajorMinorVersions(short[][] majorMinor) {
        int length = majorMinor.length;
        ArrayList<Integer> result = new ArrayList<Integer>(length);
        for (int i = 0; i < length; ++i) {
            result.add(ClassFile.getVersionInt(majorMinor[i][0], majorMinor[i][1]));
        }
        return result;
    }

    private static boolean isSupportedVersion(short major, short minor) {
        Integer version = ClassFile.getVersionInt(major, minor);
        return jdkVersions.contains(version);
    }

    private static Integer getVersionInt(short major, short minor) {
        return new Integer(major * 65536 + minor);
    }

    public static final String printSupportedVersions() {
        StringBuffer buf = new StringBuffer("{");
        int length = jdkMajorMinorVersions.length;
        for (int i = 0; i < length; ++i) {
            short major = jdkMajorMinorVersions[i][0];
            short minor = jdkMajorMinorVersions[i][1];
            buf.append("{");
            buf.append(major);
            buf.append(",");
            buf.append(minor);
            buf.append("}");
        }
        buf.append("}");
        return buf.toString();
    }
}

