/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ObjectStreamException;
import java.io.Serializable;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.Container;
import org.jboss.weld.bean.ContextualInstance;
import org.jboss.weld.bean.proxy.AbstractBeanInstance;
import org.jboss.weld.contexts.CreationalContextImpl;
import org.jboss.weld.contexts.WeldCreationalContext;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.injection.EmptyInjectionPoint;
import org.jboss.weld.injection.ThreadLocalStack;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.logging.ContextLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.util.reflection.Reflections;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="bean field is loaded lazily")
public class ContextBeanInstance<T>
extends AbstractBeanInstance
implements Serializable {
    private static final long serialVersionUID = -8144230657830556503L;
    private transient Bean<T> bean;
    private final BeanIdentifier id;
    private final String contextId;
    private final transient Class<?> instanceType;
    private final transient BeanManagerImpl manager;
    private final transient CurrentInjectionPoint currentInjectionPoint;
    private static final ThreadLocal<WeldCreationalContext<?>> currentCreationalContext = new ThreadLocal();

    public ContextBeanInstance(Bean<T> bean, BeanIdentifier id, String contextId) {
        this.bean = bean;
        this.id = id;
        this.contextId = contextId;
        this.instanceType = this.computeInstanceType(bean);
        BeanLogger.LOG.createdContextInstance(bean, id);
        this.manager = Container.instance(contextId).deploymentManager();
        this.currentInjectionPoint = this.manager.getServices().get(CurrentInjectionPoint.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getInstance() {
        if (!Container.isSet(this.contextId)) {
            throw ContextLogger.LOG.contextualReferenceNotValidAfterShutdown(this.bean, this.contextId);
        }
        T existingInstance = ContextualInstance.getIfExists(this.bean, this.manager);
        if (existingInstance != null) {
            return existingInstance;
        }
        WeldCreationalContext<?> previousCreationalContext = currentCreationalContext.get();
        WeldCreationalContext<T> creationalContext = previousCreationalContext == null ? new CreationalContextImpl<T>(this.bean) : previousCreationalContext.getCreationalContext(this.bean);
        currentCreationalContext.set(creationalContext);
        ThreadLocalStack.ThreadLocalStackReference<InjectionPoint> stack = this.currentInjectionPoint.push(EmptyInjectionPoint.INSTANCE);
        try {
            T t = ContextualInstance.get(this.bean, this.manager, creationalContext);
            return t;
        }
        finally {
            stack.pop();
            if (previousCreationalContext == null) {
                currentCreationalContext.remove();
            } else {
                currentCreationalContext.set(previousCreationalContext);
            }
        }
    }

    public Class<T> getInstanceType() {
        return (Class)Reflections.cast(this.instanceType);
    }

    private Object readResolve() throws ObjectStreamException {
        Bean bean = (Bean)Container.instance(this.contextId).services().get(ContextualStore.class).getContextual(this.id);
        return new ContextBeanInstance<T>(bean, this.id, this.contextId);
    }
}

