/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.group;

import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.net.Protocol;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQIPServiceFactory;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.service.imq.group.GroupService;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import java.io.IOException;

public class GroupServiceFactory
extends IMQIPServiceFactory {
    private static boolean SHARED_ALLOWED = false;

    @Override
    public void checkFactoryHandlerName(String handlerName) throws IllegalAccessException {
        String myname1 = "shared_old";
        String myname2 = "group_old";
        if (!myname1.equals(handlerName) && !myname2.equals(handlerName)) {
            throw new IllegalAccessException("Unexpected service Handler name " + handlerName + ", expected " + myname1);
        }
    }

    @Override
    public Service createService(String instancename, int type) throws BrokerException {
        if (!SHARED_ALLOWED) {
            Globals.getLogger().log(32, "B3123", (Object)Globals.getBrokerResources().getString("B0035"));
            Broker.getBroker().exit(1, Globals.getBrokerResources().getKString("B3123", Globals.getBrokerResources().getString("B0035")), BrokerEvent.Type.FATAL_ERROR);
        }
        if (!Globals.getConfig().getBooleanProperty("imq." + instancename + ".override")) {
            Globals.getConfig().put("imq." + instancename + ".tcp.blocking", "false");
            Globals.getConfig().put("imq." + instancename + ".tcp.useChannels", "true");
        } else {
            Globals.getLogger().log(4, "Overriding shared properties for instance " + instancename);
        }
        return super.createService(instancename, type);
    }

    @Override
    protected IMQService createService(String instancename, Protocol proto, PacketRouter router, int type, int min, int max) throws IOException {
        proto.configureBlocking(false);
        return new GroupService(instancename, proto, type, router, min, max);
    }

    static {
        try {
            LicenseBase license = Globals.getCurrentLicense(null);
            SHARED_ALLOWED = license.getBooleanProperty("imq.enable_sharedpool", false);
        }
        catch (BrokerException ex) {
            SHARED_ALLOWED = false;
        }
    }
}

