/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.bridge.api.BridgeServiceManager;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import java.util.Hashtable;

public class HelloHandler
extends AdminCmdHandler {
    private static boolean DEBUG = HelloHandler.getDEBUG();

    public HelloHandler(AdminDataHandler parent) {
        super(parent);
    }

    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": Got Hello: " + cmd_props);
        }
        Packet reply = new Packet(con.useDirectBuffers());
        reply.setPacketType(5);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("JMQMessageType", 29);
        props.put("JMQInstanceName", Globals.getConfigName());
        props.put("JMQStatus", 200);
        try {
            if (cmd_msg.getDestination().equals("__JMQBridgeAdmin")) {
                BridgeServiceManager bsm = null;
                if (!Globals.bridgeEnabled()) {
                    String emsg = this.rb.getKString("B2214");
                    this.logger.log(16, emsg);
                    props.put("JMQStatus", 503);
                    props.put("JMQErrorString", emsg);
                } else {
                    bsm = Globals.getBridgeServiceManager();
                    if (bsm == null || !bsm.isRunning()) {
                        String emsg = this.rb.getKString("B2215");
                        this.logger.log(16, emsg);
                        props.put("JMQStatus", 503);
                        props.put("JMQErrorString", emsg);
                    } else {
                        reply.setReplyTo(bsm.getAdminDestinationName());
                        reply.setReplyToClass(bsm.getAdminDestinationClassName());
                    }
                }
            }
        }
        catch (Exception e) {
            String emsg = "XXXI18N in processing admin message: " + e.getMessage();
            this.logger.logStack(32, emsg, (Throwable)e);
            props.put("JMQStatus", 500);
            props.put("JMQErrorString", emsg);
        }
        reply.setProperties(props);
        this.parent.sendReply(con, cmd_msg, reply);
        return true;
    }
}

