/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core.migration;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.UniqueID;
import java.io.ObjectStreamException;

public class ConsumerUID
extends UID {
    static final long serialVersionUID = 5231476734057401743L;
    protected transient int ackType = 0;
    protected transient ConnectionUID conuid = null;
    protected transient BrokerAddress brokeraddr = Globals.getMyAddress();
    protected transient boolean shouldStore = false;

    public ConsumerUID() {
    }

    public ConsumerUID(long id) {
        super(id);
    }

    public ConsumerUID(boolean empty) {
        super(0L);
        if (!empty) {
            this.initializeID();
        }
    }

    @Deprecated
    public ConsumerUID(int oldnum) {
        super((long)oldnum);
    }

    public boolean shouldStore() {
        return this.shouldStore;
    }

    public void setShouldStore(boolean store) {
        this.shouldStore = store;
    }

    public boolean isEmpty() {
        return this.id == 0L;
    }

    public void initializeID() {
        if (this.id == 0L) {
            this.id = UniqueID.generateID((short)ConsumerUID.getPrefix());
        }
    }

    public void clear() {
        this.id = 0L;
        this.conuid = null;
        this.brokeraddr = null;
        this.ackType = 0;
    }

    public void updateUID(ConsumerUID uid) {
        this.id = uid.id;
    }

    public void copy(ConsumerUID uid) {
        this.id = uid.id;
        this.conuid = uid.conuid;
        this.brokeraddr = uid.brokeraddr;
        this.ackType = uid.ackType;
    }

    public boolean isAutoAck() {
        return this.ackType == 1;
    }

    public String getAckMode(int mode) {
        switch (this.ackType) {
            case 1: {
                return "AUTO_ACKNOWLEDGE";
            }
            case 3: {
                return "DUPS_OK_ACKNOWLEDGE";
            }
            case 2: {
                return "CLIENT_ACKNOWLEDGE";
            }
            case 32768: {
                return "NO_ACK_ACKNOWLEDGE";
            }
        }
        return "NONE";
    }

    public boolean isDupsOK() {
        return this.ackType == 3;
    }

    public boolean isNoAck() {
        return this.ackType == 32768;
    }

    public boolean isUnsafeAck() {
        return this.isDupsOK() || this.isNoAck();
    }

    public void setAckType(int mode) {
        this.ackType = mode;
    }

    public void setConnectionUID(ConnectionUID cid) {
        this.conuid = cid;
    }

    public ConnectionUID getConnectionUID() {
        return this.conuid;
    }

    public void setBrokerAddress(BrokerAddress bkraddr) {
        this.brokeraddr = bkraddr;
    }

    public BrokerAddress getBrokerAddress() {
        if (this.brokeraddr == null) {
            this.brokeraddr = Globals.getMyAddress();
        }
        return this.brokeraddr;
    }

    public String toString() {
        return "[consumer:" + super.toString() + ", type=" + this.getAckMode(this.ackType) + "]";
    }

    public Object readResolve() throws ObjectStreamException {
        com.sun.messaging.jmq.jmsserver.core.ConsumerUID obj = new com.sun.messaging.jmq.jmsserver.core.ConsumerUID(this.id);
        return obj;
    }
}

