/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

abstract class BinaryLogicalOperatorNode
extends BinaryOperatorNode {
    boolean shortCircuitValue;

    BinaryLogicalOperatorNode(ValueNode valueNode, ValueNode valueNode2, String string, ContextManager contextManager) {
        super(valueNode, valueNode2, string, string, "org.apache.derby.iapi.types.BooleanDataValue", "org.apache.derby.iapi.types.BooleanDataValue", contextManager);
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        if (this.leftOperand.isParameterNode() || this.rightOperand.isParameterNode()) {
            throw StandardException.newException("42X19.S.2", new Object[0]);
        }
        super.bindExpression(fromList, subqueryList, list);
        return this;
    }

    @Override
    boolean verifyEliminateNots() {
        return true;
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.leftOperand.generateExpression(expressionClassBuilder, methodBuilder);
        methodBuilder.dup();
        methodBuilder.push(this.shortCircuitValue);
        methodBuilder.callMethod((short)185, null, "equals", "boolean", 1);
        methodBuilder.conditionalIf();
        methodBuilder.callMethod((short)185, null, "getImmutable", "org.apache.derby.iapi.types.BooleanDataValue", 0);
        methodBuilder.startElseCode();
        this.rightOperand.generateExpression(expressionClassBuilder, methodBuilder);
        methodBuilder.upCast("org.apache.derby.iapi.types.BooleanDataValue");
        methodBuilder.callMethod((short)185, null, this.methodName, "org.apache.derby.iapi.types.BooleanDataValue", 1);
        methodBuilder.completeConditional();
    }

    DataTypeDescriptor resolveLogicalBinaryOperator(DataTypeDescriptor dataTypeDescriptor, DataTypeDescriptor dataTypeDescriptor2) throws StandardException {
        if (!dataTypeDescriptor.getTypeId().isBooleanTypeId() || !dataTypeDescriptor2.getTypeId().isBooleanTypeId()) {
            throw StandardException.newException("42Y94", new Object[0]);
        }
        return dataTypeDescriptor.getNullabilityType(dataTypeDescriptor.isNullable() || dataTypeDescriptor2.isNullable());
    }
}

