/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient.protocol.http;

import com.sun.messaging.PropertyOwner;
import com.sun.messaging.jmq.jmsclient.ConnectionHandler;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.MQAddress;
import com.sun.messaging.jmq.jmsclient.StreamHandler;
import com.sun.messaging.jmq.jmsclient.protocol.http.HTTPConnectionHandler;
import com.sun.messaging.jmq.jmsclient.protocol.ssl.SSLUtil;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import javax.jms.JMSException;

public class HTTPStreamHandler
implements StreamHandler,
PropertyOwner {
    @Override
    public String[] getPropertyNames() {
        String[] propnames = new String[]{"imqConnectionURL"};
        return propnames;
    }

    @Override
    public String getPropertyType(String propname) {
        if ("imqConnectionURL".equals(propname)) {
            return "java.lang.String";
        }
        return null;
    }

    @Override
    public String getPropertyLabel(String propname) {
        if ("imqConnectionURL".equals(propname)) {
            return "L0506";
        }
        return null;
    }

    @Override
    public String getPropertyDefault(String propname) {
        if ("imqConnectionURL".equals(propname)) {
            return "http://localhost/imq/tunnel";
        }
        return null;
    }

    @Override
    public ConnectionHandler openConnection(Object connection) throws JMSException {
        return new HTTPConnectionHandler(connection);
    }

    @Override
    public ConnectionHandler openConnection(MQAddress addr, ConnectionImpl connection) throws JMSException {
        return new HTTPConnectionHandler(addr, connection);
    }

    static {
        Object[] protocols = SSLUtil.getKnownSSLEnabledProtocols();
        final String orig = Arrays.toString(protocols);
        StringBuffer buf = new StringBuffer();
        int cnt = 0;
        for (Object s : protocols) {
            if (((String)s).equals("SSLv3") || ((String)s).equals("SSLv2Hello")) continue;
            if (cnt > 0) {
                buf.append(",");
            }
            buf.append((String)s);
            ++cnt;
        }
        final String sysval = buf.toString();
        String sysprop = "https.protocols";
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (System.getProperty("https.protocols") == null) {
                    System.out.println(orig + ", System.setProperty: " + "https.protocols" + "=" + sysval);
                    System.setProperty("https.protocols", sysval);
                }
                return null;
            }
        });
    }
}

