/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.transaction;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.transaction.Transaction;
import javax.transaction.Transactional;
import javax.transaction.TransactionalException;
import org.glassfish.cdi.transaction.TransactionalInterceptorBase;

@Priority(value=200)
@Interceptor
@Transactional(value=Transactional.TxType.NOT_SUPPORTED)
public class TransactionalInterceptorNotSupported
extends TransactionalInterceptorBase {
    private static final Logger _logger = Logger.getLogger("javax.enterprise.resource.jta", "org.glassfish.cdi.LogMessages");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object transactional(InvocationContext ctx) throws Exception {
        _logger.log(Level.INFO, "AS-JTA-00006");
        if (this.isLifeCycleMethod(ctx)) {
            return this.proceed(ctx);
        }
        this.setTransactionalTransactionOperationsManger(true);
        try {
            Transaction transaction = null;
            if (this.getTransactionManager().getTransaction() != null) {
                _logger.log(Level.INFO, "AS-JTA-00007");
                try {
                    transaction = this.getTransactionManager().suspend();
                }
                catch (Exception exception) {
                    String messageString = "Managed bean with Transactional annotation and TxType of NOT_SUPPORTED called inside a transaction context.  Suspending transaction failed due to " + exception;
                    _logger.log(Level.INFO, "AS-JTA-00008", exception);
                    throw new TransactionalException(messageString, (Throwable)exception);
                }
            }
            Object proceed = null;
            try {
                proceed = this.proceed(ctx);
            }
            finally {
                if (transaction != null) {
                    try {
                        this.getTransactionManager().resume(transaction);
                    }
                    catch (Exception exception) {
                        String messageString = "Managed bean with Transactional annotation and TxType of NOT_SUPPORTED encountered exception during resume " + exception;
                        throw new TransactionalException(messageString, (Throwable)exception);
                    }
                }
            }
            Object object = proceed;
            return object;
        }
        finally {
            this.resetTransactionOperationsManager();
        }
    }
}

