/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.debugger;

import java.util.function.Supplier;
import org.eclipse.gemoc.commons.eclipse.logging.ILoggingEntity;
import org.eclipse.gemoc.commons.eclipse.logging.backends.DefaultLoggingBackend;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.api.MessagingSystem;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.api.MessagingSystemManager;
import org.eclipse.gemoc.commons.eclipse.pde.GemocPlugin;
import org.eclipse.gemoc.executionframework.debugger.OmniscientGenericSequentialModelDebugger;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.osgi.framework.BundleContext;

public class Activator
extends GemocPlugin {
    public static final String PLUGIN_ID = "org.eclipse.gemoc.executionframework.debugger";
    private static Activator plugin;
    private Supplier<IExecutionEngine<?>> engineSupplier;
    private Supplier<String> bundleSymbolicNameSupplier;
    private Supplier<OmniscientGenericSequentialModelDebugger> debuggerSupplier;
    private boolean useNestedDebugVariables = true;
    private DefaultLoggingBackend _loggingBackend;

    public void setHandlerFieldSuppliers(Supplier<IExecutionEngine<?>> engineSupplier, Supplier<String> bundleSymbolicNameSupplier) {
        this.engineSupplier = engineSupplier;
        this.bundleSymbolicNameSupplier = bundleSymbolicNameSupplier;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public String getId() {
        return PLUGIN_ID;
    }

    public DefaultLoggingBackend resolveLoggingBackend() {
        if (this._loggingBackend == null) {
            this._loggingBackend = new DefaultLoggingBackend((ILoggingEntity)this);
            MessagingSystemManager msm = new MessagingSystemManager();
            MessagingSystem ms = msm.createBestPlatformMessagingSystem(PLUGIN_ID, "Model Debugger console");
            this._loggingBackend.setMessagingSystem(ms);
        }
        return this._loggingBackend;
    }

    public Supplier<IExecutionEngine<?>> getEngineSupplier() {
        return this.engineSupplier;
    }

    public Supplier<String> getBundleSymbolicNameSupplier() {
        return this.bundleSymbolicNameSupplier;
    }

    public Supplier<OmniscientGenericSequentialModelDebugger> getDebuggerSupplier() {
        return this.debuggerSupplier;
    }

    public void setDebuggerSupplier(Supplier<OmniscientGenericSequentialModelDebugger> debuggerSupplier) {
        this.debuggerSupplier = debuggerSupplier;
    }

    public boolean isUseNestedDebugVariables() {
        return this.useNestedDebugVariables;
    }

    public void setUseNestedDebugVariables(boolean useNestedDebugVariables) {
        this.useNestedDebugVariables = useNestedDebugVariables;
    }
}

