/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.k3.dsa.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.k3.Activator;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.k3.dsa.api.IK3DSAExecutorClassLoader;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.k3.dsa.impl.AbstractAspectsCodeExecutor;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.dsa.executors.CodeExecutionException;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.dsa.executors.ICodeExecutor;
import org.eclipse.gemoc.trace.commons.model.trace.MSEOccurrence;

public class Kermeta3AspectsCodeExecutor
extends AbstractAspectsCodeExecutor
implements ICodeExecutor {
    protected IK3DSAExecutorClassLoader k3DSAExecutorClassLoader;
    protected String bundleSymbolicName;

    public Kermeta3AspectsCodeExecutor(IK3DSAExecutorClassLoader k3DSAExecutorClassLoader, String bundleSymbolicName) {
        this.k3DSAExecutorClassLoader = k3DSAExecutorClassLoader;
        this.bundleSymbolicName = bundleSymbolicName;
    }

    public Object execute(MSEOccurrence mseOccurrence) throws CodeExecutionException {
        EObject caller = mseOccurrence.getMse().getCaller();
        String methodName = mseOccurrence.getMse().getAction().getName();
        return this.internal_execute(caller, methodName, (Collection<Object>)mseOccurrence.getParameters(), mseOccurrence);
    }

    public Object execute(Object caller, String methodName, List<Object> parameters) throws CodeExecutionException {
        return this.internal_execute(caller, methodName, parameters, null);
    }

    private Object internal_execute(Object caller, String methodName, Collection<Object> parameters, MSEOccurrence mseOccurrence) throws CodeExecutionException {
        Method bestApplicableMethod;
        ArrayList<Object> staticParameters = new ArrayList<Object>();
        staticParameters.add(caller);
        if (parameters != null) {
            staticParameters.addAll(parameters);
        }
        if ((bestApplicableMethod = this.getBestApplicableMethod(caller, methodName, staticParameters)) == null) {
            throw new CodeExecutionException("static class not found or method not found when calling " + methodName + " on " + caller + ". MSEOccurence=" + mseOccurrence, mseOccurrence, false);
        }
        Object[] args = new Object[]{};
        if (staticParameters != null) {
            args = staticParameters.toArray();
        }
        Object result = null;
        try {
            result = bestApplicableMethod.invoke(null, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            throw new CodeExecutionException("Exception caught during execution of a call, see inner exception.", e, mseOccurrence, true);
        }
        return result;
    }

    private Method getBestApplicableMethod(Object caller, String methodName, List<Object> parameters) {
        Set<Class<?>> staticHelperClasses = this.getStaticHelperClasses(caller);
        if (staticHelperClasses == null || staticHelperClasses.isEmpty()) {
            return null;
        }
        for (Class<?> c : staticHelperClasses) {
            Method m = this.getFirstApplicableMethod(c, methodName, parameters);
            if (m == null) continue;
            return m;
        }
        return null;
    }

    protected Method getFirstApplicableMethod(Class<?> staticHelperClass, String methodName, List<Object> parameters) {
        Method[] methods;
        Method[] methodArray = methods = staticHelperClass.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Class<?>[] evaluatedMethodParamTypes = method.getParameterTypes();
            if (method.getName().equals(methodName) && evaluatedMethodParamTypes.length == parameters.size()) {
                boolean isAllParamCompatible = true;
                int i = 0;
                while (i < evaluatedMethodParamTypes.length) {
                    Object p = parameters.get(i);
                    if (evaluatedMethodParamTypes[i].isPrimitive()) {
                        if (evaluatedMethodParamTypes[i].equals(Integer.TYPE) && !Integer.class.isInstance(p)) {
                            isAllParamCompatible = false;
                            break;
                        }
                        if (evaluatedMethodParamTypes[i].equals(Boolean.TYPE) && !Boolean.class.isInstance(p)) {
                            isAllParamCompatible = false;
                            break;
                        }
                    } else if (!evaluatedMethodParamTypes[i].isInstance(p)) {
                        isAllParamCompatible = false;
                        break;
                    }
                    ++i;
                }
                if (isAllParamCompatible) {
                    return method;
                }
            }
            ++n2;
        }
        Class<?> superClass = staticHelperClass.getSuperclass();
        if (superClass != null) {
            return this.getFirstApplicableMethod(superClass, methodName, parameters);
        }
        return null;
    }

    @Override
    protected Set<Class<?>> getStaticHelperClasses(Object target) {
        String possibleStaticClassesNames;
        block12: {
            List<Class<?>> allPossibleInterfaces = this.getInterfacesClassOfEObjectOrClass(target);
            String searchedPropertyFileName = "/META-INF/xtend-gen/" + this.bundleSymbolicName + ".k3_aspect_mapping.properties";
            Properties properties = new Properties();
            InputStream inputStream = this.k3DSAExecutorClassLoader.getResourceAsStream(searchedPropertyFileName);
            if (inputStream == null) {
                try {
                    inputStream = Platform.getBundle((String)this.bundleSymbolicName).getEntry(searchedPropertyFileName).openStream();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            possibleStaticClassesNames = null;
            try {
                if (inputStream == null) break block12;
                properties.load(inputStream);
                int i = 0;
                while (i < allPossibleInterfaces.size()) {
                    possibleStaticClassesNames = properties.getProperty(allPossibleInterfaces.get(i).getCanonicalName());
                    if (possibleStaticClassesNames == null) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                return null;
            }
        }
        if (possibleStaticClassesNames == null) {
            return null;
        }
        HashSet classes = new HashSet();
        ClassNotFoundException possibleException = null;
        String[] stringArray = possibleStaticClassesNames.replaceAll(" ", "").split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String possibleName = stringArray[n2];
            try {
                classes.add(this.k3DSAExecutorClassLoader.getClassForName(possibleName));
            }
            catch (ClassNotFoundException e) {
                possibleException = e;
            }
            ++n2;
        }
        if (classes.isEmpty()) {
            Activator.getMessagingSystem().error("ClassNotFoundException, see Error Log View", "org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.k3", possibleException);
        }
        return classes;
    }

    protected List<Class<?>> getInterfacesClassOfEObjectOrClass(Object o) {
        ArrayList possibleInterfaces = new ArrayList();
        if (o instanceof EObject) {
            List<Class<?>> interfaces = Kermeta3AspectsCodeExecutor.getAllInterfaces(o.getClass());
            int i = 0;
            while (i < interfaces.size()) {
                Class<?> interfac = interfaces.get(i);
                if (interfac.getSimpleName().equals(((EObject)o).eClass().getName())) {
                    possibleInterfaces.add(interfac);
                }
                ++i;
            }
        } else {
            possibleInterfaces.add(o.getClass());
        }
        return possibleInterfaces;
    }

    private static List<Class<?>> getAllInterfaces(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        LinkedHashSet interfacesFound = new LinkedHashSet();
        Kermeta3AspectsCodeExecutor.getAllInterfaces(cls, interfacesFound);
        return new ArrayList(interfacesFound);
    }

    private static void getAllInterfaces(Class<?> cls, HashSet<Class<?>> interfacesFound) {
        while (cls != null) {
            Class<?>[] interfaces;
            Class<?>[] classArray = interfaces = cls.getInterfaces();
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> i = classArray[n2];
                if (interfacesFound.add(i)) {
                    Kermeta3AspectsCodeExecutor.getAllInterfaces(i, interfacesFound);
                }
                ++n2;
            }
            cls = cls.getSuperclass();
        }
    }

    public String getExcutorID() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.bundleSymbolicName + "]";
    }
}

