/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml.internal;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Stack;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputSource;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.editor.xml.internal.NodeOperation;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlUtils {
    private static final Logger log = LoggerFactory.getLogger(XmlUtils.class);

    public static Element findChild(Element parent, String name) {
        return PomEdits.findChild((Element)parent, (String)name);
    }

    public static List<Element> findChilds(Element parent, String name) {
        return PomEdits.findChilds((Element)parent, (String)name);
    }

    public static String getTextValue(Node element) {
        return PomEdits.getTextValue((Node)element);
    }

    public static Element findChild(Element parent, String name, PomEdits.Matcher ... matchers) {
        return PomEdits.findChild((Element)parent, (String)name, (PomEdits.Matcher[])matchers);
    }

    public static IProject extractProject(ITextViewer sourceViewer) {
        IFile res;
        ITextFileBuffer buf = FileBuffers.getTextFileBufferManager().getTextFileBuffer(sourceViewer.getDocument());
        if (buf == null) {
            return null;
        }
        IFileStore folder = buf.getFileStore();
        File file = new File(folder.toURI());
        IPath path = Path.fromOSString((String)file.getAbsolutePath());
        Stack<IFile> stack = new Stack<IFile>();
        IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
        if (ifile != null) {
            stack.push(ifile);
        }
        while (path.segmentCount() > 1) {
            IResource ires = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (ires != null && ires instanceof IFile) {
                stack.push((IFile)ires);
            }
            path = path.removeFirstSegments(1);
        }
        IFile iFile = res = stack.empty() ? null : (IFile)stack.pop();
        if (res != null) {
            IProject prj = res.getProject();
            if (res.getProjectRelativePath().segmentCount() != 1) {
                prj = null;
            }
            return prj;
        }
        return null;
    }

    public static MavenProject extractMavenProject(ITextViewer sourceViewer) {
        if (sourceViewer instanceof IAdaptable) {
            return (MavenProject)((IAdaptable)sourceViewer).getAdapter(MavenProject.class);
        }
        return null;
    }

    public static File fileForInputLocation(InputLocation location, MavenProject origin) {
        InputSource source = location.getSource();
        if (source != null) {
            String loc = source.getLocation();
            File file = null;
            if (loc != null) {
                file = new File(loc);
            } else {
                String modelId = source.getModelId();
                if (origin.getModel().getId().equals(modelId) && origin.getFile() != null) {
                    return origin.getFile();
                }
                String[] splitStrings = modelId.split(":");
                assert (splitStrings.length == 3);
                IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().getMavenProject(splitStrings[0], splitStrings[1], splitStrings[2]);
                if (facade != null) {
                    file = facade.getPomFile();
                } else {
                    IMaven maven = MavenPlugin.getMaven();
                    try {
                        String path = maven.getArtifactPath(maven.getLocalRepository(), splitStrings[0], splitStrings[1], splitStrings[2], "pom", null);
                        if (path != null) {
                            file = new File(maven.getLocalRepositoryPath(), path);
                        }
                    }
                    catch (CoreException e) {
                        log.error("Failed to calculate local repository path of artifact", (Throwable)e);
                    }
                }
            }
            return file;
        }
        return null;
    }

    public static void performOnCurrentElement(IDocument document, int offset, NodeOperation<Node> operation) {
        assert (document != null);
        assert (operation != null);
        IStructuredModel sModel = null;
        try {
            sModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            if (sModel != null) {
                IndexedRegion inode = sModel.getIndexedRegion(offset);
                if (inode == null) {
                    inode = sModel.getIndexedRegion(offset - 1);
                }
                if (inode instanceof Node) {
                    operation.process((Node)inode, sModel.getStructuredDocument());
                }
            }
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
    }

    public static void performOnRootElement(IDocument doc, NodeOperation<Element> operation) {
        assert (doc != null);
        assert (operation != null);
        IDOMModel domModel = null;
        try {
            domModel = (IDOMModel)StructuredModelManager.getModelManager().getExistingModelForRead(doc);
            if (domModel == null) {
                throw new IllegalArgumentException("Document is not structured: " + doc);
            }
            IStructuredDocument document = domModel.getStructuredDocument();
            Element root = domModel.getDocument().getDocumentElement();
            operation.process(root, document);
        }
        finally {
            if (domModel != null) {
                domModel.releaseFromRead();
            }
        }
    }

    public static void performOnRootElement(IFile resource, NodeOperation<Element> operation) throws IOException, CoreException {
        XmlUtils.performOnRootElement(resource, operation, false);
    }

    public static void performOnRootElement(IFile resource, NodeOperation<Element> operation, boolean autoSave) throws IOException, CoreException {
        assert (resource != null);
        assert (operation != null);
        IDOMModel domModel = null;
        try {
            domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForRead(resource);
            if (domModel == null) {
                throw new IllegalArgumentException("Document is not structured: " + resource);
            }
            IStructuredDocument document = domModel.getStructuredDocument();
            Element root = domModel.getDocument().getDocumentElement();
            operation.process(root, document);
            if (autoSave && domModel.getReferenceCountForEdit() == 0) {
                domModel.save();
            }
        }
        finally {
            if (domModel != null) {
                domModel.releaseFromRead();
            }
        }
    }

    public static String pathUp(Node node, int level) {
        StringBuffer buf = new StringBuffer();
        int current = level;
        while (node != null && current > 0) {
            if (node instanceof Element) {
                if (buf.length() > 0) {
                    buf.insert(0, "/");
                }
                buf.insert(0, node.getNodeName());
                --current;
            }
            node = node.getParentNode();
        }
        return buf.toString();
    }
}

