/**
 * Copyright (c) 2016, 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.trace.commons;

import com.google.common.base.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EcoreFactory;

@SuppressWarnings("all")
public abstract class ExecutionMetamodelTraceability {
  public final static String TRACEABILITY_ANNOTATION_SOURCE = "http://www.modelexecution.org/trace/XMOF";
  
  public final static String TRACEABILITY_ANNOTATION_KEY = "executionMetamodelElement";
  
  public static void createTraceabilityAnnotation(final EModelElement elementToAnnotate, final String traceabilityAnnotationValue) {
    final EAnnotation traceabilityAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
    traceabilityAnnotation.setSource(ExecutionMetamodelTraceability.TRACEABILITY_ANNOTATION_SOURCE);
    EMap<String, String> _details = traceabilityAnnotation.getDetails();
    _details.put(ExecutionMetamodelTraceability.TRACEABILITY_ANNOTATION_KEY, traceabilityAnnotationValue);
    EList<EAnnotation> _eAnnotations = elementToAnnotate.getEAnnotations();
    _eAnnotations.add(traceabilityAnnotation);
  }
  
  public static String getTraceabilityAnnotationValue(final EModelElement annotatedElement) {
    String traceabilityAnnotationValue = null;
    final EAnnotation traceabilityAnnotation = ExecutionMetamodelTraceability.getTraceabilityAnnotation(annotatedElement);
    boolean _notEquals = (!Objects.equal(traceabilityAnnotation, null));
    if (_notEquals) {
      EMap<String, String> _details = traceabilityAnnotation.getDetails();
      String _get = _details.get(ExecutionMetamodelTraceability.TRACEABILITY_ANNOTATION_KEY);
      traceabilityAnnotationValue = _get;
    }
    return traceabilityAnnotationValue;
  }
  
  public static EAnnotation getTraceabilityAnnotation(final EModelElement annotatedElement) {
    return annotatedElement.getEAnnotation(ExecutionMetamodelTraceability.TRACEABILITY_ANNOTATION_SOURCE);
  }
}
