/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import javax.net.ssl.SSLEngine;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.Processor;
import org.apache.coyote.ajp.AbstractAjpProtocol;
import org.apache.coyote.ajp.AjpNio2Processor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.Nio2Channel;
import org.apache.tomcat.util.net.Nio2Endpoint;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class AjpNio2Protocol
extends AbstractAjpProtocol<Nio2Channel> {
    private static final Log log = LogFactory.getLog(AjpNio2Protocol.class);
    private final AjpConnectionHandler cHandler;

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected AbstractEndpoint.Handler getHandler() {
        return this.cHandler;
    }

    public AjpNio2Protocol() {
        this.endpoint = new Nio2Endpoint();
        this.cHandler = new AjpConnectionHandler(this);
        ((Nio2Endpoint)this.endpoint).setHandler(this.cHandler);
        this.setSoLinger(-1);
        this.setSoTimeout(-1);
        this.setTcpNoDelay(true);
        ((Nio2Endpoint)this.endpoint).setUseSendfile(false);
    }

    @Override
    protected String getNamePrefix() {
        return "ajp-nio2";
    }

    protected static class AjpConnectionHandler
    extends AbstractAjpProtocol.AbstractAjpConnectionHandler<Nio2Channel, AjpNio2Processor>
    implements Nio2Endpoint.Handler {
        protected final AjpNio2Protocol proto;

        public AjpConnectionHandler(AjpNio2Protocol proto) {
            this.proto = proto;
        }

        @Override
        protected AbstractProtocol<Nio2Channel> getProtocol() {
            return this.proto;
        }

        @Override
        protected Log getLog() {
            return log;
        }

        @Override
        public SSLImplementation getSslImplementation() {
            return null;
        }

        @Override
        public void release(SocketWrapper<Nio2Channel> socket) {
            Processor processor = (Processor)this.connections.remove(socket.getSocket());
            if (processor != null) {
                processor.recycle(true);
                this.recycledProcessors.push(processor);
            }
        }

        @Override
        public void release(SocketWrapper<Nio2Channel> socket, Processor<Nio2Channel> processor, boolean isSocketClosing, boolean addToPoller) {
            processor.recycle(isSocketClosing);
            this.recycledProcessors.push(processor);
            if (addToPoller) {
                ((Nio2Endpoint)this.proto.endpoint).awaitBytes(socket);
            }
        }

        @Override
        protected AjpNio2Processor createProcessor() {
            AjpNio2Processor processor = new AjpNio2Processor(this.proto.packetSize, (Nio2Endpoint)this.proto.endpoint);
            this.proto.configureProcessor(processor);
            this.register(processor);
            return processor;
        }

        @Override
        public void onCreateSSLEngine(SSLEngine engine) {
        }

        @Override
        public void closeAll() {
            for (Nio2Channel channel : this.connections.keySet()) {
                ((Nio2Endpoint)this.proto.endpoint).closeSocket(channel.getSocket(), SocketStatus.STOP);
            }
        }
    }
}

