/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.tomcat.JarScanFilter;
import org.apache.tomcat.JarScanType;
import org.osgi.framework.BundleContext;

final class BundleDependenciesJarScanFilter
implements JarScanFilter {
    private static final String COMMA_SEPARATOR = ",";
    static final String SCANNER_SKIP_BUNDLES_PROPERTY_NAME = "org.eclipse.gemini.web.tomcat.scanner.skip.bundles";
    private static final String SCANNER_SKIP_BUNDLES_PROPERTY_VALUE_DEFAULT = "org.eclipse.osgi,javax.servlet,javax.servlet.jsp,javax.el,javax.websocket,javax.security.auth.message";
    private final Set<String> skipBundles;

    BundleDependenciesJarScanFilter(BundleContext bundleContext) {
        this.skipBundles = Collections.unmodifiableSet(this.getBundlesToSkip(bundleContext));
    }

    public boolean check(JarScanType jarScanType, String bundleSymbolicName) {
        return !this.skipBundles.contains(bundleSymbolicName);
    }

    private Set<String> getBundlesToSkip(BundleContext bundleContext) {
        HashSet<String> result = new HashSet<String>();
        String property = bundleContext.getProperty(SCANNER_SKIP_BUNDLES_PROPERTY_NAME);
        if (property == null) {
            property = SCANNER_SKIP_BUNDLES_PROPERTY_VALUE_DEFAULT;
        }
        String[] bundlesNames = property.split(COMMA_SEPARATOR);
        int i = 0;
        while (bundlesNames != null && i < bundlesNames.length) {
            result.add(bundlesNames[i]);
            ++i;
        }
        return result;
    }
}

