/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.naming;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.directory.DirContext;
import javax.naming.spi.InitialContextFactory;
import org.eclipse.gemini.naming.CloseableContextManager;
import org.eclipse.gemini.naming.OSGiInitialContextFactoryBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

class ContextManagerImpl
implements CloseableContextManager {
    private static final Logger logger = Logger.getLogger(ContextManagerImpl.class.getName());
    private final OSGiInitialContextFactoryBuilder m_builder;
    private final Map<Context, Object> m_listOfContexts = Collections.synchronizedMap(new WeakHashMap());

    ContextManagerImpl(Bundle callingBundle, BundleContext implBundleContext) {
        this.m_builder = new OSGiInitialContextFactoryBuilder(callingBundle.getBundleContext(), implBundleContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Context newInitialContext() throws NamingException {
        OSGiInitialContextFactoryBuilder oSGiInitialContextFactoryBuilder = this.m_builder;
        synchronized (oSGiInitialContextFactoryBuilder) {
            Context initialContext = this.createNewInitialContext(new Hashtable());
            this.m_listOfContexts.put(initialContext, null);
            return initialContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Context newInitialContext(Map environment) throws NamingException {
        OSGiInitialContextFactoryBuilder oSGiInitialContextFactoryBuilder = this.m_builder;
        synchronized (oSGiInitialContextFactoryBuilder) {
            Context initialContext = this.createNewInitialContext(environment);
            this.m_listOfContexts.put(initialContext, null);
            return initialContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DirContext newInitialDirContext() throws NamingException {
        OSGiInitialContextFactoryBuilder oSGiInitialContextFactoryBuilder = this.m_builder;
        synchronized (oSGiInitialContextFactoryBuilder) {
            Context contextToReturn = this.createNewInitialContext(new Hashtable());
            if (contextToReturn instanceof DirContext) {
                this.m_listOfContexts.put(contextToReturn, null);
                return (DirContext)contextToReturn;
            }
        }
        throw new NoInitialContextException("DirContext could not be created.  The matching InitialContextFactory did not create a matching type.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DirContext newInitialDirContext(Map environment) throws NamingException {
        OSGiInitialContextFactoryBuilder oSGiInitialContextFactoryBuilder = this.m_builder;
        synchronized (oSGiInitialContextFactoryBuilder) {
            Context context = this.createNewInitialContext(environment);
            if (context instanceof DirContext) {
                this.m_listOfContexts.put(context, null);
                return (DirContext)context;
            }
        }
        throw new NoInitialContextException("DirContext could not be created.  The matching InitialContextFactory did not create a matching type.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.m_listOfContexts;
        synchronized (object) {
            Set<Context> iterator = this.m_listOfContexts.keySet();
            if (iterator != null) {
                for (Context context : iterator) {
                    try {
                        context.close();
                    }
                    catch (NamingException e) {
                        logger.log(Level.INFO, "NamingException occurred while trying to close an existing JNDI Context", e);
                    }
                }
            }
        }
        this.m_listOfContexts.clear();
        object = this.m_builder;
        synchronized (object) {
            this.m_builder.close();
        }
    }

    private Context createNewInitialContext(Map environment) throws NamingException {
        Hashtable jndiEnvironment = new Hashtable(environment);
        InitialContextFactory factory = this.m_builder.createInitialContextFactory(jndiEnvironment);
        return factory.getInitialContext(jndiEnvironment);
    }
}

