/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.validation;

import com.google.inject.Inject;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.validation.NamesAreUniqueValidator;

public class RoomNamesAreUniqueValidator
extends NamesAreUniqueValidator {
    @Inject
    protected IQualifiedNameProvider fqnProvider;

    public void checkUniqueNamesInResourceOf(EObject eObject) {
        QualifiedName restrictedFQN;
        if (!(eObject instanceof RoomModel) && this.getContext() != null && (restrictedFQN = (QualifiedName)this.fqnProvider.apply((Object)eObject)) != null && restrictedFQN != QualifiedName.EMPTY) {
            this.getContext().put(this, restrictedFQN);
        }
        super.checkUniqueNamesInResourceOf(eObject);
    }

    public void acceptError(String message, EObject object, EStructuralFeature feature, int index, String code, String ... issueData) {
        if (this.acceptNamespace(object)) {
            super.acceptError(message, object, feature, index, code, issueData);
        }
    }

    public void acceptError(String message, EObject object, int offset, int length, String code, String ... issueData) {
        if (this.acceptNamespace(object)) {
            super.acceptError(message, object, offset, length, code, issueData);
        }
    }

    protected boolean acceptNamespace(EObject eObject) {
        Map context = this.getContext();
        if (context != null && context.containsKey((Object)this)) {
            QualifiedName restrictedFQN = (QualifiedName)context.get((Object)this);
            QualifiedName eObjectFQN = (QualifiedName)this.fqnProvider.apply((Object)eObject);
            if (eObjectFQN != null && eObjectFQN.startsWith(restrictedFQN)) {
                if (eObjectFQN.equals((Object)restrictedFQN)) {
                    return eObject == this.getCurrentObject();
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public void register(EValidatorRegistrar registrar) {
    }
}

