/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.fsm.naming;

import com.google.common.base.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.fsm.fSM.CPBranchTransition;
import org.eclipse.etrice.core.fsm.fSM.ChoicePoint;
import org.eclipse.etrice.core.fsm.fSM.ChoicepointTerminal;
import org.eclipse.etrice.core.fsm.fSM.ContinuationTransition;
import org.eclipse.etrice.core.fsm.fSM.GuardedTransition;
import org.eclipse.etrice.core.fsm.fSM.InitialTransition;
import org.eclipse.etrice.core.fsm.fSM.MessageFromIf;
import org.eclipse.etrice.core.fsm.fSM.NonInitialTransition;
import org.eclipse.etrice.core.fsm.fSM.RefinedState;
import org.eclipse.etrice.core.fsm.fSM.RefinedTransition;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.fSM.StateGraphItem;
import org.eclipse.etrice.core.fsm.fSM.StateTerminal;
import org.eclipse.etrice.core.fsm.fSM.SubStateTrPointTerminal;
import org.eclipse.etrice.core.fsm.fSM.TrPoint;
import org.eclipse.etrice.core.fsm.fSM.TrPointTerminal;
import org.eclipse.etrice.core.fsm.fSM.Transition;
import org.eclipse.etrice.core.fsm.fSM.TransitionTerminal;
import org.eclipse.etrice.core.fsm.fSM.Trigger;
import org.eclipse.etrice.core.fsm.fSM.TriggeredTransition;
import org.eclipse.etrice.core.fsm.fSM.util.FSMSwitch;

public class FSMNameProvider {
    public static final String TOP_STATE_NAME = "TOP";
    public static final String PATH_SEP = "_";
    private FSMNameProviderSwitch fsmNameProvider = new FSMNameProviderSwitch();

    public String getName(EObject item) {
        String name = (String)this.fsmNameProvider.doSwitch(item);
        if (name == null) {
            name = item.toString();
        }
        return name;
    }

    public String getFullPath(StateGraphItem item) {
        return this.getParentPath(item) + this.getName(item);
    }

    public String getFullPath(StateGraph sg) {
        if (sg.eContainer() instanceof State) {
            return this.getFullPath((State)sg.eContainer());
        }
        return TOP_STATE_NAME;
    }

    public String getStatePathName(State s) {
        return this.getParentPath(s) + this.getStateName(s);
    }

    public String getTransitionName(Transition t) {
        String toName = this.getTerminalName(t.getTo());
        if (t instanceof InitialTransition) {
            return "TRANS_INITIAL_TO__" + toName;
        }
        String fromName = this.getTerminalName(((NonInitialTransition)t).getFrom());
        String fromTo = "TRANS_" + t.getName() + "_FROM_" + fromName + "_TO_" + toName;
        if (t instanceof TriggeredTransition) {
            if (fromName.equals(toName)) {
                return fromTo + "_BY_" + this.getTriggerName((TriggeredTransition)t) + PATH_SEP + t.getName();
            }
            return fromTo + "_BY_" + this.getTriggerName((TriggeredTransition)t);
        }
        if (t instanceof ContinuationTransition) {
            return fromTo;
        }
        if (t instanceof CPBranchTransition) {
            return fromTo + "_COND_" + t.getName();
        }
        if (t instanceof GuardedTransition) {
            return fromTo + "_GUARD_" + t.getName();
        }
        assert (false) : "Unexpected transition class " + t.eClass().getName();
        return null;
    }

    public String getStateName(State s) {
        if (s == null) {
            return TOP_STATE_NAME;
        }
        return s.getName();
    }

    private boolean isTopLevel(StateGraphItem item) {
        return item == null ? true : !(item.eContainer().eContainer() instanceof State);
    }

    private State getParentState(StateGraphItem item) {
        if (this.isTopLevel(item)) {
            return null;
        }
        return (State)item.eContainer().eContainer();
    }

    public String getMessageName(EObject obj) {
        if (obj.eIsProxy()) {
            return "";
        }
        EStructuralFeature name = obj.eClass().getEStructuralFeature("name");
        assert (name != null) : "org.eclipse.etrice.core.fsm.naming.FSMNameProvider.getMessageName(EObject) should be called with an abstract message which has to have a name attribute";
        if (name == null) {
            return "";
        }
        return (String)obj.eGet(name);
    }

    private String getTriggerName(TriggeredTransition tr) {
        Object result = "";
        for (Trigger tri : tr.getTriggers()) {
            for (MessageFromIf mif : tri.getMsgFromIfPairs()) {
                result = (String)result + this.getMessageName(mif.getMessage()) + mif.getFrom().getName();
            }
        }
        return result;
    }

    public String getTerminalLabel(TransitionTerminal tt) {
        return this.getTerminalName(tt, "/");
    }

    private String getTerminalName(TransitionTerminal tt) {
        return this.getTerminalName(tt, PATH_SEP);
    }

    private String getTerminalName(TransitionTerminal tt, String sep) {
        if (tt instanceof StateTerminal) {
            return this.getStateName(((StateTerminal)tt).getState());
        }
        if (tt instanceof TrPointTerminal) {
            return ((TrPointTerminal)tt).getTrPoint().getName();
        }
        if (tt instanceof SubStateTrPointTerminal) {
            return this.getStatePathName(((SubStateTrPointTerminal)tt).getState()) + sep + ((SubStateTrPointTerminal)tt).getTrPoint().getName();
        }
        if (tt instanceof ChoicepointTerminal) {
            return ((ChoicepointTerminal)tt).getCp().getName();
        }
        assert (false) : "Unexpected TransitionTerminal class " + tt.eClass().getName();
        return null;
    }

    private String getParentPath(StateGraphItem item) {
        State parent;
        if (item instanceof RefinedState) {
            item = ((RefinedState)item).getTarget();
        }
        if ((parent = this.getParentState(item)) == null) {
            return "";
        }
        return this.getStatePathName(parent) + PATH_SEP;
    }

    public Function<RefinedState, String> getRefinedStateNameProvider() {
        return new Function<RefinedState, String>(){

            public String apply(RefinedState rs) {
                return FSMNameProvider.this.getFullPath(rs);
            }
        };
    }

    public String getTransitionLabelName(Transition t) {
        Object name = null;
        if (t instanceof InitialTransition) {
            return "init";
        }
        name = t.getName() != null ? t.getName() + ": " : "";
        NonInitialTransition nit = (NonInitialTransition)t;
        if (nit.getFrom() instanceof ChoicepointTerminal) {
            CPBranchTransition cpt;
            if (nit instanceof ContinuationTransition) {
                return (String)name + "[else]";
            }
            if (nit instanceof CPBranchTransition && (cpt = (CPBranchTransition)nit).getCondition() != null && !cpt.getCondition().getLines().isEmpty()) {
                return (String)name + "[" + (String)cpt.getCondition().getLines().get(0) + "]";
            }
            return (String)name + "[?]";
        }
        if (t instanceof TriggeredTransition) {
            boolean first = true;
            for (Trigger trig : ((TriggeredTransition)t).getTriggers()) {
                if (first) {
                    first = false;
                } else {
                    name = (String)name + "or";
                }
                name = (String)name + this.getTriggerLabel(trig);
            }
        }
        if (t instanceof GuardedTransition) {
            name = (String)name + " guard {" + (String)((GuardedTransition)t).getGuard().getLines().get(0) + "}";
        }
        return name;
    }

    public String getTriggerLabel(Trigger trig) {
        Object name = "<";
        boolean first = true;
        for (MessageFromIf mif : trig.getMsgFromIfPairs()) {
            if (first) {
                first = false;
            } else {
                name = (String)name + "|";
            }
            name = (String)name + this.getMsgFromIfLabel(mif);
        }
        if (trig.getGuard() != null && !trig.getGuard().getGuard().getLines().isEmpty()) {
            name = (String)name + " guard {" + (String)trig.getGuard().getGuard().getLines().get(0) + "}";
        }
        return (String)name + ">";
    }

    public String getMsgFromIfLabel(MessageFromIf mif) {
        String from = mif.getFrom() != null ? ":" + mif.getFrom().getName() : "";
        return this.getMessageName(mif.getMessage()) + from;
    }

    public String getStateGraphLabel(StateGraph sg) {
        if (sg.eContainer() instanceof State) {
            State s = (State)sg.eContainer();
            return this.getStatePathLabel(s);
        }
        return "/";
    }

    public String getStatePathLabel(State s) {
        if (s.eContainer().eContainer() instanceof State) {
            return this.getStatePathLabel((State)s.eContainer().eContainer()) + "/" + s.getName();
        }
        return "/" + s.getName();
    }

    protected class FSMNameProviderSwitch
    extends FSMSwitch<String> {
        @Override
        public String caseState(State object) {
            return FSMNameProvider.this.getStateName(object);
        }

        @Override
        public String caseChoicePoint(ChoicePoint object) {
            return object.getName();
        }

        @Override
        public String caseTrPoint(TrPoint object) {
            return object.getName();
        }

        @Override
        public String caseTransition(Transition object) {
            return FSMNameProvider.this.getTransitionName(object);
        }

        @Override
        public String caseRefinedTransition(RefinedTransition object) {
            return FSMNameProvider.this.getTransitionName(object.getTarget());
        }
    }
}

